//
#include <Shaders/VisionCommon.inc>
#include <Shaders/ShaderHelpers.inc>

#ifdef _VISION_DX11
  Texture2D <float4> BaseTexture        : register(t0);
  sampler            BaseTextureSampler : register(s0);
#else
  sampler2D          BaseTexture        : register(s0);
#endif

#if defined(_VISION_PS3) || defined(_VISION_PSP2) || defined(_VISION_GLES2) || defined(_VISION_WIIU)
  #ifdef USE_COLOR_TRANSFORM
    float4x4 ColorTransform    : register(c32);
  #endif
  
  #ifdef USE_MOTIONBLUR
	  float    BlurFactor        : register(c36);
  #endif
  
  float4 AdaptiveParams        : register(c37);
  
#elif defined(_VISION_DX11)
  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    #ifdef USE_COLOR_TRANSFORM
      float4x4 ColorTransform  : packoffset(c0);
    #endif
  
    #ifdef USE_MOTIONBLUR
	    float    BlurFactor      : packoffset(c4);
    #endif
    
    float4 AdaptiveParams      : packoffset(c5);
  }
#else
  #ifdef USE_COLOR_TRANSFORM
    float4x4 ColorTransform;
  #endif
  
  #ifdef USE_MOTIONBLUR
    float    BlurFactor;
  #endif
  
  float4 AdaptiveParams;  
#endif

struct PS_IN
{                  
  float4 ProjPos  : SV_Position;
  half2 UV0 : TEXCOORD0; 
};

float3 RGB2XYZ(float3 c)
{
  float3x3 map = { 0.5141364, 0.3238786,  0.16036376,
                   0.265068,  0.67023428, 0.06409157,
                   0.0241188, 0.1228178,  0.84442666 };
  return mul(map, c);
  /*
  float3x3 map = { 0.49,    0.31,    0.20,
                   0.17697, 0.81240, 0.01063,
                   0,       0.01,    0.99 };
  return mul(map, c / 0.17697);*/
}

float3 XYZ2RGB(float3 c)
{
  float3x3 map = { 2.5651, -1.1665, -0.3986,
                  -1.0217,  1.9777,  0.0439, 
                   0.0753, -0.2543,  1.1892};
  return mul(map, c);
}

float3 XYZ2xyY(float3 c)
{
  float denom = 1.0 / (c.x + c.y + c.z);
  return float3(c.x * denom, c.y * denom, c.y);
}

float3 xyY2XYZ(float3 c)
{
  return float3(c.z * c.x / c.y, c.z, c.z * (1 - c.x - c.y) / c.y);
}

float3 RGB2YUV(float3 c)
{
  float3x3 map = { 0.299, 0.587, 0.114,
                  -0.14713,  -0.28886, 0.436,
                   0.615, -0.51499, -0.10001 };
  return mul(map, c);
}

float3 YUV2RGB(float3 c)
{
  float3x3 map = { 1, 0, 1.13983,
                   1, -0.39465, -0.58060,
                   1, 2.03211, 0 };
  return mul(map, c);
}

float Reinhard(float L)
{
  float Exposure = AdaptiveParams.x;
  float AvgLuminance = AdaptiveParams.y;
  float White = AdaptiveParams.z;

  float Lp = L * Exposure / AvgLuminance;
  
  float Lwsq = White * White;
  return Lp * (1 + Lp / Lwsq) / (1 + Lp);
}

float HejlBurgessDawson(float L)
{
  float Exposure = AdaptiveParams.x;
  float AvgLuminance = AdaptiveParams.y;
  float White = AdaptiveParams.z;

  float Lp = L * Exposure / AvgLuminance;
  L = max(0, Lp-0.004);
  return pow((L*(6.2*L+0.5f)) / (L*(6.2*L+1.7) + 0.06), 2.2);
}

float4 ps_main( PS_IN In ) : SV_Target
{
  float4 scaledRGBA = vTex2D(BaseTexture, BaseTextureSampler, In.UV0);
  
  float3 col = XYZ2xyY(RGB2XYZ(scaledRGBA.xyz));
  
  col.z = Reinhard(col.z);
  
  scaledRGBA.xyz = float4(saturate(XYZ2RGB(xyY2XYZ(col))), scaledRGBA.w);
  
  $if defined(GAMMA_CORRECTION) && !defined(GAMMA_CORRECTION_POST_TRANSFORM)
    scaledRGBA.xyz = LinearToSRGB(scaledRGBA.xyz);
  $endif

  float4 result = scaledRGBA;

  #ifdef USE_COLOR_TRANSFORM
    #ifdef USE_LUMINANCE
      float fLuminance = (scaledRGBA.r+scaledRGBA.g+scaledRGBA.b)*0.33333f;
      scaledRGBA /= 1.0f + fLuminance;
	  #endif
  
    scaledRGBA.a = 1.0f;
    result = mul(scaledRGBA, ColorTransform);
  #endif
  
$ifdef GAMMA_CORRECTION_POST_TRANSFORM
  result.xyz = LinearToSRGB(result.xyz);
$endif    
  
  #ifdef USE_MOTIONBLUR
    result.a = BlurFactor;
  #endif
  
  return result;
}
