//
#define DEFERRED_OUTPUT

// notify the inc files that we have custom streams and want to use a custom diffuse color
#define USE_USTOM_VERTEX_STREAMS
#define USE_CUSTOM_DIFFUSE_COLOR

// CUSTOM_VS_IN_STREAMS: our additional In streams (as defined in the mesh)
#if (DETAIL_TEXTURE_COUNT==1)
  #define CUSTOM_VS_IN_STREAMS \
    float2 UVDetail1 : TEXCOORD1;
#elif (DETAIL_TEXTURE_COUNT==2)
  #define CUSTOM_VS_IN_STREAMS \
    float2 UVDetail1 : TEXCOORD1;\
    float2 UVDetail2 : TEXCOORD5;
#elif (DETAIL_TEXTURE_COUNT==3)
  #define CUSTOM_VS_IN_STREAMS \
    float2 UVDetail1 : TEXCOORD1;\
    float2 UVDetail2 : TEXCOORD5;\
    float2 UVDetail3 : TEXCOORD6;
#elif (DETAIL_TEXTURE_COUNT==4)
  #define CUSTOM_VS_IN_STREAMS \
    float2 UVDetail1 : TEXCOORD1;\
    float2 UVDetail2 : TEXCOORD5;\
    float2 UVDetail3 : TEXCOORD6;\
    float2 UVDetail4 : TEXCOORD7;
#endif

// CUSTOM_VS_OUT_STREAMS: our additional VS->PS streams. Pack them, because we don't have enough interpolators
#if (DETAIL_TEXTURE_COUNT==1)
  #define CUSTOM_VS_OUT_STREAMS \
      float2 UVDetail1and2 : TEXCOORD6;
#elif (DETAIL_TEXTURE_COUNT==2)
  #define CUSTOM_VS_OUT_STREAMS \
      float4 UVDetail1and2 : TEXCOORD6;
#elif (DETAIL_TEXTURE_COUNT==3)
  #define CUSTOM_VS_OUT_STREAMS \
      float4 UVDetail1and2 : TEXCOORD6;\
      float2 UVDetail3and4 : TEXCOORD7;
#elif (DETAIL_TEXTURE_COUNT==4)
  #define CUSTOM_VS_OUT_STREAMS \
      float4 UVDetail1and2 : TEXCOORD6;\
      float4 UVDetail3and4 : TEXCOORD7;
#endif
  
// PassCustomVertexStreams: a "function" that passes through the custom streams from VS to PS
#if (DETAIL_TEXTURE_COUNT==1)
  #define PassCustomVertexStreams(target, source) \
    target.UVDetail1and2.xy = source.UVDetail1;
#elif (DETAIL_TEXTURE_COUNT==2)
  #define PassCustomVertexStreams(target, source) \
    target.UVDetail1and2.xy = source.UVDetail1;\
    target.UVDetail1and2.zw = source.UVDetail2;
#elif (DETAIL_TEXTURE_COUNT==3)
  #define PassCustomVertexStreams(target, source) \
    target.UVDetail1and2.xy = source.UVDetail1;\
    target.UVDetail1and2.zw = source.UVDetail2;\
    target.UVDetail3and4.xy = source.UVDetail3;
#elif (DETAIL_TEXTURE_COUNT==4)
  #define PassCustomVertexStreams(target, source) \
    target.UVDetail1and2.xy = source.UVDetail1;\
    target.UVDetail1and2.zw = source.UVDetail2;\
    target.UVDetail3and4.xy = source.UVDetail3;\
    target.UVDetail3and4.zw = source.UVDetail4;
#endif


#ifdef _IS_VERTEX_SHADER

// nothing else to do here
#include <Shaders/DeferredShadingVS.inc>

#endif


#ifdef _IS_PIXEL_SHADER

// define additional textures. If the used sampler indices (3-6) conflict with other features (e.g. lightmaps), just move them accordingly
#ifdef _VISION_DX11
  sampler            DetailTextureSampler  : register(s3); // common sampler for all detail textures
  Texture2D <float4> DetailTexture1        : register(t3);
  Texture2D <float4> DetailTexture2        : register(t4);
  Texture2D <float4> DetailTexture3        : register(t5);
  Texture2D <float4> DetailTexture4        : register(t6);
#else
  sampler2D          DetailTexture1        : register(s3);
  sampler2D          DetailTexture2        : register(s4);
  sampler2D          DetailTexture3        : register(s5);
  sampler2D          DetailTexture4        : register(s6);
#endif

// GetCustomDiffuseColor : a "function" to apply our detail textures
#if (DETAIL_TEXTURE_COUNT==1)
  #define GetCustomDiffuseColor(_diffuse, _baseUV) \
    float4 d1 = vTex2D(DetailTexture1, DetailTextureSampler, In.UVDetail1and2.xy); \
    _diffuse *= d1;
#elif (DETAIL_TEXTURE_COUNT==2)
  #define GetCustomDiffuseColor(_diffuse, _baseUV) \
    float4 d1 = vTex2D(DetailTexture1, DetailTextureSampler, In.UVDetail1and2.xy); \
    _diffuse *= d1; \
    float4 d2 = vTex2D(DetailTexture2, DetailTextureSampler, In.UVDetail1and2.zw); \
    _diffuse *= d2;
#elif (DETAIL_TEXTURE_COUNT==3)
  #define GetCustomDiffuseColor(_diffuse, _baseUV) \
    float4 d1 = vTex2D(DetailTexture1, DetailTextureSampler, In.UVDetail1and2.xy); \
    _diffuse *= d1; \
    float4 d2 = vTex2D(DetailTexture2, DetailTextureSampler, In.UVDetail1and2.zw); \
    _diffuse *= d2; \
    float4 d3 = vTex2D(DetailTexture3, DetailTextureSampler, In.UVDetail3and4.xy); \
    _diffuse *= d3;
#elif (DETAIL_TEXTURE_COUNT==4)
  #define GetCustomDiffuseColor(_diffuse, _baseUV) \
    float4 d1 = vTex2D(DetailTexture1, DetailTextureSampler, In.UVDetail1and2.xy); \
    _diffuse *= d1; \
    float4 d2 = vTex2D(DetailTexture2, DetailTextureSampler, In.UVDetail1and2.zw); \
    _diffuse *= d2; \
    float4 d3 = vTex2D(DetailTexture3, DetailTextureSampler, In.UVDetail3and4.xy); \
    _diffuse *= d3; \
    float4 d4 = vTex2D(DetailTexture4, DetailTextureSampler, In.UVDetail3and4.zw); \
    _diffuse *= d4;
#endif
  
#include <Shaders/DeferredShadingPS.inc>



#endif
