//
#include <shaders/VisionCommon.inc>
#include <shaders/DeferredShadingHelpers.inc>

#define InputBuffer Texture2DMS<float4, $MSAA_SAMPLES>

InputBuffer ColorTexture : register (t0);
sampler     ColorTextureSampler : register(s0);

struct PS_IN
{
  float4 ProjPos : SV_Position;
  float2 UV : TexCoord;

  uint uiSampleIndex : SV_SampleIndex;
};

float4 ps_main( PS_IN In ) : COLOR0
{
  int2 uv = int2 (In.ProjPos.xy);
  
  float f = 0;
  for (int i = 0; i < $MSAA_SAMPLES; i++)
  {
    float4 color = ColorTexture.Load (uv, i);
	
    f += color.a;//min (color.a - 0.0001, 0.999 - color.a);
  }
  clip(f - 0.001f);
  return 1;
}