//
#include <Shaders/VisionCommon.inc>
#include <Shaders/ShaderHelpers.inc>
#include "DeferredShadingHelpers.inc"

$if MSAA_SAMPLES > 1
  V_REQUIRES_SM40
  #define InputBuffer Texture2DMS<float4, $MSAA_SAMPLES>
$else
  #define InputBuffer Texture2D<float4>
$endif


#ifdef _VISION_DX11
  InputBuffer        DepthSpecBuffer    : register(t0);
  sampler            DepthSpecSampler   : register(s0);
  
  cbuffer g_GlobalConstantBufferFrame : register (b0)
  {
    float3 cFogColor : packoffset(c20);
  }
  
#else
  sampler2D DepthSpecBuffer : register(s0);
  float3 cFogColor : register(c1);
#endif  



struct PS_IN                                 
{                                             
  float4 ProjPos  : SV_Position;              
  float4 UV0_DepthFog : TEXCOORD0;
};


float4 ps_main( PS_IN In ) : SV_Target              
{
  float4 fogColor = float4 (cFogColor.rgb, 0);
  float2 UV0 = In.UV0_DepthFog.xy;
  float2 DepthFog = In.UV0_DepthFog.zw;

  $if MSAA_SAMPLES > 1

	  int2 uv = int2 (In.ProjPos.xy);
				
		for (int i = 0; i < $MSAA_SAMPLES; i++)
		{
			float fDepth = DepthSpecBuffer.Load (uv.xy, i);
      fogColor.a += saturate(fDepth * DepthFog.y - DepthFog.x); 
		}
	
		fogColor.a /= $MSAA_SAMPLES;
		
	$else

    float fDepth = READ_CONVERTED_DEPTH(DepthSpecBuffer, DepthSpecSampler, UV0);
	
    fogColor.a = saturate(fDepth * DepthFog.y - DepthFog.x); 
 
	$endif
	
	return fogColor;
}
