#include <Shaders/VisionCommon.inc>
#include <Shaders/ShaderHelpers.inc>
#include <shaders/vMaterialPermutationsStaticLit.inc>
#include "DeferredShadingHelpers.inc"

#ifdef _VISION_DX11
  Texture2D <float4> BaseTexture          : register(t0);
  sampler            BaseTextureSampler   : register(s0);
  $ifdef VMATERIAL_NORMALMAP
    Texture2D <float4> NormalMap          : register(t1);
    sampler            NormalMapSampler   : register(s1);
  $endif
  $ifdef VMATERIAL_REFMAP
    Texture2D <float4> RefMap             : register(t2);
    sampler            RefMapSampler      : register(s2);
  $endif
  $ifdef LIGHTMAP
    Texture2D <float4> LightMap           : register(t3);
    sampler            LightMapSampler    : register(s3);
  $endif
  $ifdef LIGHTMAPDOT3
    Texture2D <float4> LightMap1          : register(t3);
    sampler            LightMapSampler1   : register(s3);
    Texture2D <float4> LightMap2          : register(t4);
    sampler            LightMapSampler2   : register(s4);
    Texture2D <float4> LightMap3          : register(t5);
    sampler            LightMapSampler3   : register(s5);
  $endif
  $if defined(VMATERIAL_GLOWMAP) || defined(VMATERIAL_GLOWMAP_ADDITIVE)
    Texture2D <float4> GlowMap            : register(t6);
    sampler            GlowMapSampler     : register(s6);
  $endif
  
  cbuffer g_GlobalConstantBufferFrame     : register (b0)
  {
    float4    gAmbientCol                 : packoffset(c21);  // global ambient color
    float4    lightmapMul                 : packoffset(c22);  // lightmap multiplier (scalar) 
  }
  
  cbuffer g_GlobalConstantBufferUser      : register (b2)
  {
    float4 MaterialParams                 : packoffset(c0);
    float3 MaterialAmbient                : packoffset(c1);
 
    float  fAlphaTestThreshold            : packoffset(c2);
    float  GlobalAmbientMultiplier        : packoffset(c3);
    
    float  gMaterialIndex : packoffset(c4);
  
  $if defined(VMATERIAL_GLOWMAP) || defined(VMATERIAL_GLOWMAP_ADDITIVE) 
    float3 GlowColor                      : packoffset(c5);
    float GlowIntensity                   : packoffset(c6);  
  $endif
  }  
    
  $ifdef LIGHTGRID
    cbuffer g_GlobalConstantBufferLightGrid : register (b3)
    {
      float4      Light0                  : packoffset(c0);
      float4      Light1                  : packoffset(c1);
      float4      Light2                  : packoffset(c2);
      float4      Light3                  : packoffset(c3);
      float4      Light4                  : packoffset(c4);
      float4      Light5                  : packoffset(c5);
    }
  $endif
  
#else
  sampler2D BaseTexture                   : register(s0);

  $ifdef VMATERIAL_NORMALMAP
    sampler2D NormalMap                   : register(s1);
  $endif

  $ifdef VMATERIAL_REFMAP
    sampler2D RefMap                      : register(s2);
  $endif

  $ifdef LIGHTMAP
    sampler2D LightMap                    : register(s3);
  $endif

  $ifdef LIGHTMAPDOT3
    sampler2D LightMap1                   : register(s3);
    sampler2D LightMap2                   : register(s4);
    sampler2D LightMap3                   : register(s5);
  $endif
  


  float4 lightmapMul : register(c0);

  float3 gAmbientCol : register(c21);
  float4 MaterialParams : register(c32);
  float3 MaterialAmbient : register(c33);

  float  fAlphaTestThreshold : register(c34);
  float  GlobalAmbientMultiplier : register(c35);
  
  float  gMaterialIndex : register(c36);
  
  $ifdef LIGHTGRID 
    float4 Light0 : register(c26);
    float4 Light1 : register(c27);
    float4 Light2 : register(c28);
    float4 Light3 : register(c29);
    float4 Light4 : register(c30);
    float4 Light5 : register(c31);
  $endif
  
  $if defined(VMATERIAL_GLOWMAP) || defined(VMATERIAL_GLOWMAP_ADDITIVE)
    sampler2D GlowMap           : register(s6);
    float3 GlowColor            : register(c37);
    float GlowIntensity         : register(c38);
  $endif
#endif



struct PS_IN                              
{                                             
  $ifdef MSAA
		V_REQUIRES_SM41
    centroid float4 ProjPos : SV_Position;
  $else
    float4 ProjPos : SV_Position;
  $endif
  
  float4 UV01 : TEXCOORD0;
  float3 Normal  : TEXCOORD1;

  $ifdef VMATERIAL_NORMALMAP
    float3 Tangent : TEXCOORD2;
    float3 BiTangent : TEXCOORD3;
  $endif

  float4 EyeDirAndDepth : TEXCOORD4;

  $ifdef VERTEXCOLOR
    float4 VertColor : TEXCOORD5;
  $endif
  
  $ifdef TWO_SIDED_LIGHTING
    VFACING_TYPE Facing : VFACING;
  $endif
};

#include <shaders/vMaterialHelpers.inc>                     

PS_OUT ps_main( PS_IN In )
{
  PixelDataUnpacked pixelData;

  float3 vEyeNorm = normalize(In.EyeDirAndDepth.xyz);
  float2 BaseMapCoord = GetBaseMapCoords(In.UV01.xy, vEyeNorm);
    
  float4 cBaseTex = GetDiffuseTexture(BaseMapCoord);
  
  $ifdef ALPHATEST
    clip(cBaseTex.a - fAlphaTestThreshold);
  $endif

  $ifdef FULLBRIGHT
    pixelData.vDiffColor = float3(0.0f, 0.0f, 0.0f);
  $else
    pixelData.vDiffColor = cBaseTex.xyz;
  $endif

  float4 vNormalMap = GetTangentSpaceNormal(BaseMapCoord);
  float3 worldNormal = In.Normal;
  
  $ifdef TWO_SIDED_LIGHTING
    worldNormal *= GetFacing(In.Facing);
  $endif
  
  $ifdef VMATERIAL_NORMALMAP
    worldNormal = GetWorldNormal(vNormalMap, In.Tangent, In.BiTangent, worldNormal);
  $else
    worldNormal = normalize(worldNormal);
  $endif

  pixelData.vNormal = worldNormal;

  $ifdef FULLBRIGHT
    pixelData.fSpecExp = 1.0f;
    pixelData.vSpecColor = float3(0.0f, 0.0f, 0.0f);
  $else
    float4 SpecMul = GetSpecularMultiplier(BaseMapCoord, vNormalMap.a);
    float fSpecExp = SpecMul.a;
    pixelData.fSpecExp = mapToNormalizedRangeFrom255(fSpecExp);
    pixelData.vSpecColor = saturate(SpecMul.xyz);
  $endif
  
  $ifdef LIGHTMAP
    // ordinary lightmap lighting
    pixelData.vAccInitial = (vTex2D(LightMap, LightMapSampler, In.UV01.zw).xyz*lightmapMul.x + gAmbientCol.xyz*GlobalAmbientMultiplier) * cBaseTex.xyz;
  $elif defined (LIGHTMAPDOT3)
    // lightmap dot3 lighting
    float4 cLightmap1 = vTex2D(LightMap1, LightMapSampler1, In.UV01.zw);
    float4 cLightmap2 = vTex2D(LightMap2, LightMapSampler2, In.UV01.zw);
    float4 cLightmap3 = vTex2D(LightMap3, LightMapSampler3, In.UV01.zw);

    LIGHT_RESULT_SPEC difspec = GetLightmapDot3LightingSpec(vNormalMap, cLightmap1, cLightmap2, cLightmap3, vEyeNorm, fSpecExp);
    pixelData.vAccInitial = (difspec.diffuse.xyz*lightmapMul.x + gAmbientCol.xyz*GlobalAmbientMultiplier) * cBaseTex.xyz + difspec.specular.xyz*SpecMul;
  $elif defined (LIGHTGRID)
    LIGHT_RESULT_SPEC res = GetLightGridSpec_WS(vEyeNorm, worldNormal, Light0, Light1, Light2, Light3, Light4, Light5, fSpecExp);
    pixelData.vAccInitial = (res.diffuse.xyz + gAmbientCol.xyz*GlobalAmbientMultiplier)*cBaseTex.xyz + res.specular*SpecMul;
    //pixelData.vAccInitial = pixelData.vAccInitial * 0.001f + cBaseTex.xyz;
  $elif defined (VERTEXCOLOR) 
    // no lightmap with vertex color
    pixelData.vAccInitial = (In.VertColor + gAmbientCol*GlobalAmbientMultiplier) * cBaseTex.xyz;
  $else
    pixelData.vAccInitial = (MaterialAmbient + gAmbientCol*GlobalAmbientMultiplier) * cBaseTex.xyz;
  $endif

  pixelData.fDepth = In.EyeDirAndDepth.w;

  $if defined (VMATERIAL_PARALLAX) && defined (VMATERIAL_PARALLAX_DEPTH_DISPLACEMENT)
    pixelData.fDepth += fHeight * vEyeNorm.z * 0.1f;
  $endif
  
  pixelData.fMaterial = gMaterialIndex;
  
  $if defined(VMATERIAL_GLOWMAP) || defined(VMATERIAL_GLOWMAP_ADDITIVE)
    pixelData.vAccInitial.rgb = GetGlow(BaseMapCoord, pixelData.vAccInitial.rgb, cBaseTex.xyz);
  $endif
  
  PS_OUT result = packPixelValues(pixelData);  
  
  $ifdef MSAA
    $ifdef ALPHATEST
      float edgeResponse =  max (0.9, 1.0 - min (1.0, dot(abs(frac(In.ProjPos.xy) - 0.5), 1000)));
        
      result.Accumulation.a = pow (max (0.0, (cBaseTex.a - fAlphaTestThreshold) / (1.0 - fAlphaTestThreshold)), 2.0) * edgeResponse;
    $else
      // When one or more samples aren't located in the primitive's interior, the centroid of the remaining samples won't coincide with
      // the fragment's center (which, with the SV_Position semantic, has a fractional part of 0.5 for the xy coordinates).  
      //
      // We exploit this fact to differentiate between fully interior pixels, which will only need to be sampled once during the combine
      // pass, and pixels that need to be fully multi-sampled.  The idea is to compute the distance d (Manhattan distance here, to reduce
      // roundoff errors) between the sample centroid and the fragment center (equivalently, between the fractional part of the sample
      // centroid and the (0.5,0.5) vector).  
      //
      // Resolving the corresponding render target and writing (d > 0 ? 0 : 1) into the stencil buffer then yields the desired mask.
      float edgeResponse = dot(abs(frac(In.ProjPos.xy) - 0.5), 10000000);
        
      result.Accumulation.a = edgeResponse > 0;
	  
    $endif
  $endif
  
  return result;
}



