#include <Shaders/VisionCommon.inc>
#include <Shaders/ShaderHelpers.inc>
#include "DeferredShadingHelpers.inc"

$if MSAA_SAMPLES > 1
  #define InputBuffer Texture2DMS<float4, $MSAA_SAMPLES>
  #define SampleBuffer(_tex_, _sampler_, _uv_, _slice_) _tex_.Load(_uv_, _slice_)
  #define SampleDepth(_tex_, _sampler_, _uv_, _slice_) SampleBuffer(_tex_, _sampler_, _uv_, _slice_).r
$else
  #define InputBuffer Texture2D<float4>
  #define SampleBuffer(_tex_, _sampler_, _uv_, _slice_) vTex2D(_tex_, _sampler_, _uv_)
  #define SampleDepth(_tex_, _sampler_, _uv_, _slice_) READ_CONVERTED_DEPTH(_tex_, _sampler_, _uv_)
$endif

$if (MSAA_SAMPLES > 1) && !defined (MSAA_SINGLESAMPLE)
  #define SAMPLE_COUNT $MSAA_SAMPLES
$else
  #define SAMPLE_COUNT 1
$endif

#ifdef _VISION_DX11
  InputBuffer        DiffuseBuffer    : register(t0);
  sampler            DiffuseSampler   : register(s0);
  InputBuffer        NormalBuffer    : register(t1);
  sampler            NormalSampler   : register(s1);
  InputBuffer        DepthSpecBuffer    : register(t2);
  sampler            DepthSpecSampler   : register(s2);
  
  cbuffer g_GlobalConstantBufferFrame : register (b0)
  {
    float3 vEyePosition : packoffset(c17);
    float3 vEyeDirection : packoffset(c18);
}
  
  cbuffer g_GlobalConstantBufferUser : register(b2)
  {
    float4 fRimLightParams : packoffset(c0);
    float4 fRimLightColor  : packoffset(c1);
  }
  
#else
  sampler2D DiffuseBuffer : register(s0);
  sampler2D NormalBuffer : register(s1);
  sampler2D DepthSpecBuffer : register(s2);
  
  float3 vEyePosition : register(c19);
  float3 vEyeDirection : register(c20);
  float4 fRimLightParams : register(c32);
  float4 fRimLightColor  : register(c33);
  
#endif  



struct PS_IN                                 
{                                   
  float4 ProjPos  : SV_Position;              
  float3 ViewDirection : TEXCOORD0; 
  float2 UV0 : TEXCOORD1;

  #if (SAMPLE_COUNT > 1)
    uint uiSampleIndex : SV_SampleIndex;
  #endif
};

float4 ps_main( PS_IN In ) : SV_Target
{
  float3 vEyeDir = -normalize(In.ViewDirection);
  float4 cRimColor = float4(0,0,0,0);
  
  $if MSAA_SAMPLES > 1
    int2 uv = int2 (In.ProjPos.xy);
  $else
    float2 uv = In.UV0;
  $endif	

  #if (SAMPLE_COUNT > 1)
    int iSample = In.uiSampleIndex;
  #else
    int iSample = 0;
  #endif

  float fDepth = SampleDepth(DepthSpecBuffer, DepthSpecSampler, uv, iSample);

  float3 vWorldNormal = SampleBuffer(NormalBuffer, NormalSampler, uv, iSample).xyz;
  vWorldNormal = normalize (vWorldNormal * 2.0 - 1.0);
  float fRim = pow(1.0f - saturate(dot(vEyeDir, vWorldNormal)), fRimLightParams.x);

  cRimColor.xyz = fRim;
  cRimColor.xyz *= fRimLightParams.y;
  cRimColor.xyz *= fRimLightColor.xyz;
  
  return cRimColor;
}
