
#include <Shaders/VisionCommon.inc>
#include <Shaders/ShaderHelpers.inc>
#include <Shaders/SkinningVS.inc>

#ifdef _VISION_DX11
  cbuffer g_GlobalConstantBufferFrame : register (b0)
  {
    float4x4  matP          : packoffset(c0);
    float4x4  matEye        : packoffset(c4);   // eye matrix
    float4   contextCP : packoffset(c12);  // context clip planes: near, far, 1/(far-near)
    float4   eyePos    : packoffset(c17);  // eye position
  }
  cbuffer g_GlobalConstantBufferObject : register (b1)
  {
    float4x4 matMV     : packoffset(c0);   // model view matrix
    float4x4 matMVP    : packoffset(c4);   // model view projection matrix
    float4x4 matMtoW   : packoffset(c8);   // model to worldspace matrix
    float4   MUVtoLM   : packoffset(c13);  // model UV to lightmap
  }

  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    float ZOffset; // exposed
  }
#else
  float4x4 matMV                  : register(c0);
  float4x4 matP                   : register(c4);
  float4x4 matMVP                 : register(c8);
  float4x4 matEye                 : register(c12);
  float4x4 matMtoW                : register(c20);
  float4   contextCP              : register(c24);
  float3   eyePos                 : register(c31);
  float4   MUVtoLM                : register(c60);
  float ZOffset; // exposed
$ifdef INSTANCING
  #if defined(_VISION_XENON)
    float    vertexCount; //Needed by XBOX360 instancing
  #endif
$endif
#endif

struct VS_IN                   
{                              
  float3 ObjPos   : V_VERTEX_STREAM_POSITION;

  $ifdef VERTEXCOLOR
    float4 VertColor : V_VERTEX_STREAM_COLOR;
  $endif

  float3 Normal : V_VERTEX_STREAM_NORMAL;
  float2 UV0 : V_VERTEX_STREAM_BASETEXCOORD;

  $if defined (LIGHTMAP) || defined (LIGHTMAPDOT3)
    float2 UV1 : V_VERTEX_STREAM_LIGHTMAPCOORD;
  $endif
  
  $ifdef VMATERIAL_NORMALMAP
    float3 Tangent : V_VERTEX_STREAM_TANGENT;
  $endif

  SKINNING_VERTEX_STREAMS

$ifdef INSTANCING
  float4   Row0     : TEXCOORD5;
  float4   Row1     : TEXCOORD6;
  float4   Row2     : TEXCOORD7;
$endif
};                                           

struct VS_OUT                                 
{                                             
  float4 ProjPos  : SV_Position;
  float4 UV01 : TEXCOORD0;
  float3 Normal  : TEXCOORD1;

  $ifdef VMATERIAL_NORMALMAP
    float3 Tangent : TEXCOORD2;
    float3 BiTangent: TEXCOORD3;
  $endif

  float4 EyeDirAndDepth : TEXCOORD4;

  $ifdef (VERTEXCOLOR) 
    float4 VertColor : TEXCOORD5;
  $endif
};      

#ifndef USE_SKINNING
$ifdef INSTANCING
	#if defined(_VISION_XENON)
		VS_OUT vs_main( int i : INDEX )
	#else
		VS_OUT vs_main( VS_IN In )
	#endif
$else
	VS_OUT vs_main( VS_IN In )
$endif
#else
  VS_OUT vs_main_skinning( VS_IN In )
#endif
{
  VS_OUT Out;
  
$ifdef INSTANCING
#ifndef USE_SKINNING
	#if defined(_VISION_XENON)
		VS_IN In;

		float3 vObjPos;
		float3 vNormal;
$ifdef VERTEXCOLOR
		  float4 vVertexColor;
$endif
		float2 vUV0;
$if defined (LIGHTMAP) || defined (LIGHTMAPDOT3)
		float2 vUV1;
$endif
$ifdef VMATERIAL_NORMALMAP
		  float3 vTangent;
$endif
		float4   vRow0;
		float4   vRow1;
		float4   vRow2;
		
		// Need some constructive casting so 360 compiler doesn't optimize incorrectly
		int iVertexCount = (int)vertexCount;
		int iInstanceDataIndex = (int)( (i+0.5f) / iVertexCount );
		int iGeometryVertexIndex = i - (iInstanceDataIndex * iVertexCount);

		asm
		{
		  // Fetch the Mesh Geometry Vertex Data
		  vfetch vObjPos.xyz, iGeometryVertexIndex, position0;
		  vfetch vNormal.xyz, iGeometryVertexIndex, normal;
$ifdef VERTEXCOLOR
	        vfetch vVertexColor, iGeometryVertexIndex, color0;
$endif
			vfetch vUV0.xy, iGeometryVertexIndex, texcoord0;
$if defined (LIGHTMAP) || defined (LIGHTMAPDOT3)
			vfetch vUV1.xy, iGeometryVertexIndex, texcoord1;
$endif
$ifdef VMATERIAL_NORMALMAP
			vfetch vTangent.xyz, iGeometryVertexIndex, texcoord2;
$endif
			// Fetch the Instance Data 
			vfetch vRow0, iInstanceDataIndex, texcoord5;
			vfetch vRow1, iInstanceDataIndex, texcoord6;
			vfetch vRow2, iInstanceDataIndex, texcoord7;
		};
	
		In.ObjPos.xyz = vObjPos;
		In.Normal.xyz = vNormal;
$ifdef VERTEXCOLOR
		  In.VertColor = vVertexColor;
$endif
		In.UV0 = vUV0;
$if defined (LIGHTMAP) || defined (LIGHTMAPDOT3)
		In.UV1 = vUV1;
$endif
$ifdef VMATERIAL_NORMALMAP
		  In.Tangent = vTangent;
$endif
		In.Row0 = vRow0;
		In.Row1 = vRow1;
		In.Row2 = vRow2;
		
	#endif
#endif
$endif  
  
  float4 objPos4 = float4(In.ObjPos, 1.0f);
  float3 fNormal = In.Normal;
  
  $ifdef VERTEXCOLOR
    Out.VertColor = In.VertColor;
  $endif
  
  $ifdef VMATERIAL_NORMALMAP
    float3 fTangent = In.Tangent;
  $endif
  
  #ifdef USE_SKINNING
  PREPARE_SKINNING(In.BoneIndices);
  TRANSFORM_OBJECT_POS(objPos4, In.ObjPos, In.BoneWeight);
  TRANSFORM_OBJECT_NORMAL(fNormal, In.Normal, In.BoneWeight);
  
    $ifdef VMATERIAL_NORMALMAP
      TRANSFORM_OBJECT_TANGENT(fTangent, In.Tangent, In.BoneWeight);
    $endif
  #endif  
  
  $ifdef INSTANCING
	float4 worldPos = objPos4;
    float3x3 rotationMat = float3x3(In.Row0.xyz,In.Row1.xyz,In.Row2.xyz);
    worldPos.xyz  = mul( rotationMat, worldPos.xyz );
    worldPos.xyz += float3( In.Row0.w, In.Row1.w, In.Row2.w );
    
    Out.ProjPos = mul( matP, mul( matEye, worldPos ) );
    Out.Normal  = normalize( mul(rotationMat , fNormal) );
    
    $ifdef VMATERIAL_NORMALMAP
      Out.Tangent = normalize( mul(rotationMat , fTangent) );
      Out.BiTangent = ComputeBiNormal(Out.Tangent, Out.Normal, GetHandednessCorrection(In.Tangent));
    $endif
    
    $if defined (VMATERIAL_PARALLAX) || defined (VMATERIAL_NORMALMAP)
      Out.EyeDirAndDepth.xyz = GetVectorInTextureSpace(eyePos-worldPos.xyz, Out.Tangent, Out.Normal, Out.BiTangent);
    $else
      Out.EyeDirAndDepth.xyz = float3(0.0f, 0.0f, 0.0f);
    $endif    
	Out.EyeDirAndDepth.w = GetLinearDepth(mul(matEye, worldPos).z, contextCP.y);
    
  $else
    #ifdef EXPOSE_Z_OFS
      float4 eyePos = mul(matMV, objPos4);
      float3 eyeDir = normalize(eyePos.xyz);
      eyePos.xyz += eyeDir * ZOffset;
      Out.ProjPos = mul( matP, eyePos );
    #else
      Out.ProjPos = mul( matMVP, objPos4 );
    #endif

    //output normal, tangent and bi-tangent in worldspace
    Out.Normal  = normalize( mul((float3x3)matMtoW , fNormal) );
    
    $ifdef VMATERIAL_NORMALMAP
      Out.Tangent = normalize( mul((float3x3)matMtoW , fTangent) );
      Out.BiTangent = ComputeBiNormal(Out.Tangent, Out.Normal, GetHandednessCorrection(In.Tangent));
    $endif
    
    $if defined (VMATERIAL_PARALLAX) || defined (VMATERIAL_NORMALMAP)
      float4 worldSpacePos = mul(matMtoW, objPos4);
      Out.EyeDirAndDepth.xyz = GetVectorInTextureSpace(eyePos-worldSpacePos.xyz, Out.Tangent, Out.Normal, Out.BiTangent);
    $else
      Out.EyeDirAndDepth.xyz = float3(0.0f, 0.0f, 0.0f);
    $endif
    Out.EyeDirAndDepth.w = GetLinearDepth(mul(matMV, objPos4).z, contextCP.y);
    
  $endif
    
  Out.UV01.xy = In.UV0;

  $if defined (LIGHTMAP) || defined (LIGHTMAPDOT3)
    Out.UV01.zw = In.UV1*MUVtoLM.xy+MUVtoLM.zw; // lightmap xform
  $else
    Out.UV01.zw = float2(0.f, 0.f);
  $endif  

  return Out;                              
}

