//
#include <Shaders/VisionCommon.inc>

#ifdef _VISION_DX11
cbuffer g_GlobalConstantBufferFrame : register (b0)
{
  float4x4  matInvEye       : packoffset(c8);   // inverse eye matrix
}
cbuffer g_GlobalConstantBufferObject : register (b1)
{
  float4x4 matMVP  : packoffset(c4);   // model view projection matrix
}
cbuffer g_GlobalConstantBufferUser : register (b2)
{
  float2 TransformType : packoffset(c0);
}
#else
  float4x4 matMVP    : register(c8);
  float4x4 matInvEye : register(c16);

  float2 TransformType : register(c64);
#endif

// TODO: ObjPos input can sometimes only be 2 components!

struct VS_IN
{                              
  float3 ObjPos : POSITION;
};                                           

struct VS_OUT                                 
{                                             
  float4 ProjPos  : SV_Position;

  #if defined(_VISION_DX11)
    float4 UV0 : VPOS_MANUAL;
  #elif defined(_VISION_XENON)
    float4 UV0 : TEXCOORD0;
  #endif  
 
};


VS_OUT vs_main( VS_IN In )                        
{                                              
  VS_OUT Out;     
  
  // To reduce shader permutations...
  if (TransformType.x > 0.0f)
  {
    Out.ProjPos = mul(matMVP, float4(In.ObjPos, 1.0f));
  }
  else
  {
    Out.ProjPos = float4(In.ObjPos.xy, 0.0f, 1.0f);  
    Out.ProjPos.y *= -1.0f;
  }
  
  #if defined(_VISION_DX11) || defined(_VISION_XENON)
    Out.UV0 = Out.ProjPos;
    Out.UV0.y *= -1.0f;
  #endif
  
  return Out;
}
