#include <Shaders/VisionCommon.inc>
#include <Shaders/DeferredShadingHelpers.inc>

#ifdef FORWARD_MSAA_SAMPLES 
  Texture2DMS<float, FORWARD_MSAA_SAMPLES> BaseTexture : register(s0);
#else
  #ifdef _VISION_DX11
    Texture2D <float>  BaseTexture        : register(t0);
    sampler            BaseTextureSampler : register(s0);
  #else
    sampler2D          BaseTexture        : register(s0);
  #endif
#endif

#ifdef _VISION_DX11
  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    float2 HalfTexelStepSize  : packoffset(c0);   
    float2 ScreenSize         : packoffset(c1);
  }
#else
  float2 HalfTexelStepSize : register(c32);
#endif

struct PS_IN
{
  float4 ProjPos : SV_Position;
  float2 UV0     : TEXCOORD0;
  float4 ClipPlanes : TEXCOORD1;
};

float FetchDepth(float2 uv)
{
  #ifdef FORWARD_MSAA_SAMPLES
    return BaseTexture.Load(int3(int2(uv*ScreenSize), 0), 0).r;
  #elif defined (_VISION_PS3)
    const float3 depthFactor = float3( 65536.0/16777215.0, 256.0/16777215.0, 1.0/16777215.0 );
    float4 rgbaval = vTex2D(BaseTexture, BaseTextureSampler, uv);
    return dot( round( rgbaval.arg * 255.0 ), depthFactor );    
  #else
    return vTex2D1Comp(BaseTexture, BaseTextureSampler, uv).r;
  #endif
}

#if defined(_VISION_PSP2)
  __nativecolor __regformat float ps_main( PS_IN In ) : SV_Target
#else
  float4 ps_main( PS_IN In ) : SV_Target
#endif
{
  #ifdef QUARTER_SIZE
    float fDepth = FetchDepth(In.UV0+float2(-HalfTexelStepSize.x, -HalfTexelStepSize.y));
    fDepth = max(fDepth, FetchDepth(In.UV0+float2(HalfTexelStepSize.x, HalfTexelStepSize.y)));
    fDepth = max(fDepth, FetchDepth(In.UV0+float2(-HalfTexelStepSize.x, HalfTexelStepSize.y)));
    fDepth = max(fDepth, FetchDepth(In.UV0+float2(HalfTexelStepSize.x, -HalfTexelStepSize.y)));
  #else
    float fDepth = FetchDepth(In.UV0);
  #endif

  #if defined(_VISION_PS3) || defined(_VISION_PSP2) || defined(_VISION_WIIU)
    fDepth = 2*fDepth-1;
  #endif
 
  fDepth = (In.ClipPlanes.x * In.ClipPlanes.y) / (In.ClipPlanes.y - fDepth * In.ClipPlanes.w);
  fDepth = fDepth  / In.ClipPlanes.y;
  
  #ifdef _VISION_PS3
    return COMPUTE_CONVERTED_DEPTH(fDepth);
  #elif defined(_VISION_PSP2)
    return fDepth;
  #else
    return float4(fDepth, 0.0f, 0.0f, 1.0f);
  #endif
}