#include <Shaders/VisionCommon.inc>

#ifdef _VISION_DX11
  cbuffer g_GlobalConstantBufferFrame : register (b0)
  {
    float4 ClipPlanes  : packoffset(c12);   
  }

  cbuffer g_GlobalConstantBufferObject : register (b1)
  {
    float4x4 matMVP  : packoffset(c4);   // model view projection matrix
  }
#else
  float4x4 matMVP  : register(c8);
  float4 ClipPlanes  : register(c24);   
#endif

struct VS_IN
{
  float3   ObjPos  : POSITION;
  float2   UV0     : TEXCOORD0;
};

struct VS_OUT
{
  float4   ProjPos : SV_Position;
  float2   UV0     : TEXCOORD0;
  float4   ClipPlanes : TEXCOORD1;
};

VS_OUT vs_main( VS_IN In )
{
  VS_OUT Out;
  Out.ProjPos = mul( matMVP, float4(In.ObjPos, 1.0f) );
  Out.UV0 = In.UV0;
  Out.ClipPlanes.xyz = ClipPlanes.xyz;
  Out.ClipPlanes.w = ClipPlanes.y - ClipPlanes.x;
  return Out;
}