#include <Shaders/VisionCommon.inc>
#include <Shaders/ShaderHelpers.inc>

$ifdef VMATERIAL_GLOWMAP
  V_REQUIRES_SM30_SM40L93
$endif

#ifdef _VISION_DX11
  Texture2D BaseTexture             : register(t0);
  sampler   BaseTextureSampler      : register(s0);
  
  // no dot3 lightmap
  Texture2D   Lightmap              : register(t1);
  sampler     LightmapSampler       : register(s1);
  
  $ifdef VMATERIAL_GLOWMAP
    Texture2D GlowMap               : register(t2);
    sampler   GlowMapSampler        : register(s2);
  $endif

  Texture2D <float4> DecalTexture            : register(t3);
  sampler            DecalTextureSampler     : register(s3);
  Texture2D <float4> DecalMaskTexture        : register(t4);
  sampler            DecalMaskTextureSampler : register(s5);
  
#else
  sampler2D   BaseTexture           : register(s0);
    
  sampler2D   Lightmap              : register(s1); // no dot3 lightmap
  
  $ifdef VMATERIAL_GLOWMAP
    sampler2D GlowMap               : register(s2);
  $endif	
  
  sampler2D DecalTexture            : register(s3);
  sampler2D DecalMaskTexture        : register(s4);
  
#endif

#if defined(_VISION_PS3) || defined(_VISION_PSP2) || defined(_VISION_GLES2) || defined(_VISION_WIIU)

  float4 lightmapMul                : register(c0);
  float4 depthFogCol                : register(c1);  // linear depth fog color
  
  $ifdef ALPHATEST
    float fAlphaTestThreshold       : register(c33);
  $endif
  $ifdef AMBIENT_COLOR
    float vAmbientColor             : register(c21);
    float  GlobalAmbientMultiplier  : register(c34);
  $endif
  $ifdef VMATERIAL_GLOWMAP
    float3 GlowColor                : register(c35);
    float GlowIntensity             : register(c36);
  $endif  
  float  fMaskTestThreshold         : register(c39);
  
#elif defined(_VISION_DX11)

  cbuffer g_GlobalConstantBufferFrame : register (b0)
  {
    float4    depthFogCol     : packoffset(c20);  // linear depth fog color
    $ifdef AMBIENT_COLOR
      float vAmbientColor  : packoffset(c21);
    $endif
    float4    lightmapMul     : packoffset(c22);  // lightmap multiplier (scalar) 
  }
  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    $ifdef ALPHATEST
	    float fAlphaTestThreshold : packoffset(c0);
    $endif
    $ifdef AMBIENT_COLOR
      float  GlobalAmbientMultiplier : packoffset(c1);
    $endif
    $ifdef VMATERIAL_GLOWMAP	
      float3 GlowColor 					: packoffset(c2);
      float GlowIntensity 				: packoffset(c3);	
    $endif	
    
    float  fMaskTestThreshold           : packoffset(c4);
  }

#else

  float4 lightmapMul : register(c0);
  float4 depthFogCol : register(c1);  // linear depth fog color
  
  $ifdef AMBIENT_COLOR
    float vAmbientColor  : register(c21);
    float  GlobalAmbientMultiplier;
  $endif
  
  $ifdef ALPHATEST
    float fAlphaTestThreshold;
  $endif
  
  $ifdef VMATERIAL_GLOWMAP
    float3 GlowColor            : register(c32);
    float GlowIntensity         : register(c33);
  $endif  

    float  fMaskTestThreshold   : register(c39);
#endif

struct PS_IN
{
  float4   ProjPos              : SV_Position;
  float4   Color                : COLOR0;
  float2   UV0                  : TEXCOORD0;  //diffuse
  float2   UV1                  : TEXCOORD1;  //lightmap
  $ifdef FOG
    float    fogCoord           : TEXCOORD2;
  $endif
};

float4 GetDiffuseTexture(float2 UV)
{
  return vTex2D(BaseTexture, BaseTextureSampler, UV);
}

float4 ps_main( PS_IN In ) : SV_Target
{
  // sample the textures
  float4 cColor = GetDiffuseTexture(In.UV0);
  
  // Decals
  float2 MaskMapCoord = In.UV1;
  float4 cDecalTex = vTex2D(DecalTexture    , BaseTextureSampler, In.UV0);
  float4 cMaskTex  = vTex2D(DecalMaskTexture, BaseTextureSampler, MaskMapCoord);
  
  cColor.a *= In.Color.a;
  
  $ifdef ALPHATEST
    clip(cColor.a - fAlphaTestThreshold);
    clip(fMaskTestThreshold - cMaskTex.r);
  $endif

  cColor.xyz = lerp( cDecalTex.xyz, cColor.xyz, cMaskTex.r );

  $ifdef LIGHTMAP  
    float3 LightColor = vTex2D(Lightmap, LightmapSampler, In.UV1).xyz * lightmapMul.x + In.Color.rgb;
  $else
    float3 LightColor = In.Color.rgb;
  $endif
  
  $ifdef AMBIENT_COLOR
    LightColor += vAmbientColor*GlobalAmbientMultiplier;
  $endif

  cColor.xyz *= LightColor;
  
  $ifdef VMATERIAL_GLOWMAP
    float3 cGlowTex = vTex2D(GlowMap, BaseTextureSampler, In.UV0).rgb;
    cColor.rgb += cGlowTex * GlowColor.rgb * GlowIntensity;
  $endif  

  $ifdef FOG
    cColor.xyz = GetFogColor(cColor.xyz, depthFogCol.xyz, In.fogCoord);
  $endif

  return cColor;
}
