#include <Shaders/VisionCommon.inc>
#include <Shaders/ShaderHelpers.inc>

#if defined(VMATERIAL_BUMPCUBEMAP) && !defined(VMATERIAL_BUMP)
  #define VMATERIAL_BUMP
#endif

#if defined(VMATERIAL_BUMPCUBEMAP) && !defined(VMATERIAL_CUBEMAP)
  #define VMATERIAL_CUBEMAP
#endif

#if defined(_VISION_GLES2)
  #define FIXED fixed
  #define FIXED2 fixed2
  #define FIXED3 fixed3
  #define FIXED4 fixed4
#else
  #define FIXED half
  #define FIXED2 half2
  #define FIXED3 half3
  #define FIXED4 half4
#endif

#ifdef _VISION_DX11
  Texture2D   BaseTexture         : register(t0);
  sampler     BaseTextureSampler  : register(s0);

  #if defined(VMATERIAL_BUMP) || defined(VMATERIAL_BUMPCUBEMAP)
    Texture2D   NormalMap         : register(t1);
    sampler     NormalMapSampler  : register(s1);
  #endif

  #ifndef LIGHTGRID
    Texture2D   Lightmap            : register(t2);
    sampler     LightmapSampler     : register(s2);
  #endif
  
  #if defined(VMATERIAL_CUBEMAP) || defined(VMATERIAL_BUMPCUBEMAP)
    TextureCube CubeMap             : register(t3);
    sampler     CubeMapSampler      : register(s3);
  #endif

#else
  sampler2D   BaseTexture         : register(s0);
  
  #if defined(VMATERIAL_BUMP) || defined(VMATERIAL_BUMPCUBEMAP)
    sampler2D   NormalMap           : register(s1);
  #endif
  
  #ifndef LIGHTGRID
    sampler2D   Lightmap            : register(s2);
  #endif
  
  #if defined(VMATERIAL_CUBEMAP) || defined(VMATERIAL_BUMPCUBEMAP)
    samplerCUBE CubeMap             : register(s3);
  #endif
#endif

#ifdef _VISION_DX11
  cbuffer g_GlobalConstantBufferFrame : register (b0)
  {
    float4 depthFogCol : packoffset(c20);  // linear depth fog color
  }
  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    #if defined(VMATERIAL_BUMP) || defined(VMATERIAL_BUMPANIMATED)
      float4 BumpStrength : packoffset(c0);
    #endif
  }
  cbuffer g_GlobalConstantBufferLightGrid : register (b3)
  {
    #ifdef LIGHTGRID
      float4 AmbientColor : packoffset(c0);
      float4 DiffuseColor : packoffset(c1);
    #endif
  }  
#else
  float4 depthFogCol : register(c1);  // linear depth fog color
  
  #ifdef LIGHTGRID
    float4 AmbientColor : register(c26);
    float4 DiffuseColor : register(c27);
  #endif

  #if defined(VMATERIAL_BUMP) || defined(VMATERIAL_BUMPANIMATED)
    float4 BumpStrength : register(c32);
  #endif
#endif

struct PS_IN
{
  float4 ProjPos : SV_Position;
  half4 UV0 : TEXCOORD0;  //diffuse & normalmap
  half4 UV1 : TEXCOORD1;  //lightmap

#ifdef USE_FOG
  half fogCoord : TEXCOORD2;
#endif

#if defined(VMATERIAL_BUMP) || defined(LIGHTGRID)
  half3 LightDir : TEXCOORD3;
#endif
#if (defined(LIGHTGRID) || defined(VMATERIAL_CUBEMAP)) && (!defined(VMATERIAL_BUMP) || defined(VMATERIAL_BUMPCUBEMAP))
  half3 Normal : TEXCOORD5;
#endif
#if defined(VMATERIAL_CUBEMAP)
  half3 EyeDir : TEXCOORD4;  
#endif
#if defined(VMATERIAL_BUMPCUBEMAP)  
  half3 Tangent : TEXCOORD6;
  half3 BiNormal : TEXCOORD7;
#endif
};

FIXED4 ps_main(PS_IN In) : SV_Target
{
#ifdef VMATERIAL_PARALLAX
  half fHeight = vTex2D(NormalMap, NormalMapSampler, In.UV0).a * MaterialParams.z - MaterialParams.w;
  half3 vNormEyeTS = In.EyeDir;
  half2 BaseMapCoord = In.UV0 - (vNormEyeTS.xy * fHeight);
#else
  half2 BaseMapCoord = (half2) In.UV0;
#endif

  FIXED4 base = (FIXED4) vTex2D(BaseTexture, BaseTextureSampler, BaseMapCoord);
#if defined(VMATERIAL_BUMP) && !defined(VMATERIAL_BUMPANIMATED)
  half3 normalMap = vTex2D(NormalMap, NormalMapSampler, BaseMapCoord).xyz * half(2.0) - half(1.0);
#elif defined(VMATERIAL_BUMPANIMATED)
  half3 normalMap = vTex2D(NormalMap, NormalMapSampler, In.UV1.xy).xyz * half(2.0) - half(1.0);
  normalMap = lerp(half3(0.0, 0.0, 1.0), normalMap, (half)BumpStrength.x);
  half3 normalMap2 = vTex2D(NormalMap, NormalMapSampler, In.UV1.zw).xyz * half(2.0) - half(1.0);
  normalMap += lerp(half3(0.0, 0.0, 1.0), normalMap2, (half)BumpStrength.y);
  normalMap = normalize(normalMap);
#elif defined(LIGHTGRID)
  half3 normalMap = In.Normal;
#else
  half3 normalMap = half3(0.0, 0.0, 1.0);
#endif

#if defined(VMATERIAL_BUMPCUBEMAP)
  half3 worldNormal = normalMap.x*In.Tangent + normalMap.y*In.BiNormal + normalMap.z*In.Normal;
  /*worldNormal.x = dot(normalMap, In.Tangent);
  worldNormal.y = dot(normalMap, In.BiNormal);
  worldNormal.z = dot(normalMap, In.Normal);*/
#elif defined(VMATERIAL_CUBEMAP)
  half3 worldNormal = In.Normal;
#endif

#ifndef LIGHTGRID
  FIXED3 light = vTex2D(Lightmap, LightmapSampler, In.UV1.xy).xyz;
#ifdef VMATERIAL_BUMP
  half3 bump = dot(normalMap, In.LightDir) - In.LightDir.z;
  light += bump * BumpStrength.x * light;
#endif
  light = light * FIXED(1.6);
#else
  FIXED diff = max(dot(normalMap, In.LightDir), FIXED(0.0));
  FIXED3 light = AmbientColor.xyz + DiffuseColor.xyz * diff;
#endif
  
  FIXED3 color = base.xyz;
#if defined(VMATERIAL_CUBEMAP) || defined(VMATERIAL_BUMPCUBEMAP)
  half3 reflectionVector = reflect(In.EyeDir, worldNormal);
  color += vTexCUBE(CubeMap, CubeMapSampler, reflectionVector).xyz * base.www;
#endif
  color = color * light;

#ifdef VMATERIAL_GLOW
  color = lerp(color, base.xyz, base.www);
#endif

#ifdef USE_FOG
  color = GetFogColor(color, depthFogCol.xyz, In.fogCoord);
#endif

#ifdef ALPHATEST
  return FIXED4(color, base.w);
#else
  return FIXED4(color, 1.0);
#endif
}