//
#include <Shaders/VisionCommon.inc>

#ifdef _VISION_DX11
  Texture2D <float4> ColorTex        : register(t0);
  sampler            ColorTexSampler : register(s0);
  Texture2D <float4> BlurTex         : register(t1);
  sampler            BlurTexSampler  : register(s1);
#else
  sampler2D          ColorTex        : register(s0);
  sampler2D          BlurTex         : register(s1);
#endif

#if defined(_VISION_PS3) || defined(_VISION_WIIU)
  float4 fBlurParam     : register(c32);
  float4 fInvScreenSize : register(c33);

  #ifdef USE_FOG
    float4 fFogParam      : register(c34);
    float4 fFogColor      : register(c35);
  #endif
  
#elif defined(_VISION_DX11)
  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    float4 fBlurParam     : packoffset(c0);
    float4 fInvScreenSize : packoffset(c1);
  
    #ifdef USE_FOG
      float4 fFogParam      : packoffset(c2);
      float4 fFogColor      : packoffset(c3);
    #endif
  }
#else
  float4  fBlurParam;
  float4  fInvScreenSize;
  
  #ifdef USE_FOG
    float4  fFogParam;
    float4  fFogColor;
  #endif
#endif
  
  
struct PS_IN                                 
{                                            
  float4 ProjPos  : SV_Position;
  half2 UV0 : TEXCOORD0;                  
};      

half4 ps_main( PS_IN In ) : SV_Target
{ 
  const half4 fTaps[5] = {
	  half4(-0.326212h, -0.405805h, -0.840144h, -0.073580h),
	  half4(-0.695914h,  0.457137h, -0.203345h,  0.620716h),
	  half4(0.962340h, -0.194983h,  0.473434h, -0.480026h),
	  half4(0.519456h,  0.767022h, 0.185461h, -0.893124h),
	  half4(0.507431h,  0.064425h, 0.896420h,  0.412458h) };
	
  half4 colorSum        = vTex2D(ColorTex, ColorTexSampler, In.UV0 );
  half2 centerDepthBlur = vTex2D(BlurTex, BlurTexSampler,  In.UV0 );
  
  half2 sizeCoC;
  sizeCoC.x = centerDepthBlur.y * fBlurParam.x;
  sizeCoC.y = sizeCoC.x;
  sizeCoC.xy *= fInvScreenSize.xy;
  half totalContribution = 1.0f;
  for (int i = 0; i < 5; i++)
  {
    half2 tapCoord = In.UV0 + fTaps[i].xy * sizeCoC;
    half4 tapColor     = vTex2D(ColorTex, ColorTexSampler, tapCoord );
    half2 tapDepthBlur = vTex2D(BlurTex, BlurTexSampler,  tapCoord );
    half tapContribution = (tapDepthBlur.x >= centerDepthBlur.x) ? 1.0f : tapDepthBlur.y;
    colorSum += tapColor * tapContribution;
    totalContribution += tapContribution;
    tapCoord = In.UV0 + fTaps[i].zw * sizeCoC;
    tapColor     = vTex2D(ColorTex, ColorTexSampler, tapCoord );
    tapDepthBlur = vTex2D(BlurTex, BlurTexSampler,  tapCoord );
    tapContribution = (tapDepthBlur.x >= centerDepthBlur.x) ? 1.0f : tapDepthBlur.y;
    colorSum += tapColor * tapContribution;
    totalContribution += tapContribution;
  }
  
  #ifdef USE_FOG
    half4 fColor = colorSum / totalContribution;
    half fFog = clamp((fFogParam.y - centerDepthBlur.x) / (fFogParam.y - fFogParam.x), 0.0f, 1.0f);
    return lerp(fFogColor, fColor, fFog);
  #else
    return colorSum / totalContribution;  
  #endif
}



  
