//
#include <Shaders/VisionCommon.inc>

#ifdef _VISION_DX11
  cbuffer g_GlobalConstantBufferObject : register (b1)
  {
    float4x4 matMVP  : packoffset(c4);   // model view projection matrix
  }
#else
  float4x4 matMVP  : register(c8);
#endif

// StepSize constant
#if defined(_VISION_DX11)
cbuffer g_GlobalConstantBufferUser : register (b2)
{
  float4   StepSize : packoffset(c0);
}
#else
float4   StepSize : register(c64);
#endif

struct VS_IN
{
  float3   ObjPos  : POSITION;
  float2   UV0     : TEXCOORD0;
};

struct VS_OUT
{
  float4   ProjPos : SV_Position;
  half2    UV0     : TEXCOORD0; 
};

VS_OUT vs_main( VS_IN In )
{
  VS_OUT Out;
  Out.ProjPos = mul(matMVP, float4(In.ObjPos, 1.0f));

  #if defined(_VISION_DX9) || defined(_VISION_XENON)
    Out.UV0.xy = In.UV0.xy + StepSize.xy * 0.5f;
  #else
    Out.UV0 = In.UV0;
  #endif

  return Out;
}
