
inline float GetPixDepth(float4 uv)
{
  return (clipPlanes.g-uv.z)/clipPlanes.b;
}

struct PCFUV_t
{
  float2 integerPart;
  float2 fractionalPart;
};

inline PCFUV_t GetPCFCoords(float4 uv, float2 invtexsize)
{
  PCFUV_t pcfuv;
  float2 scaledUv = (uv.xy / uv.w) / invtexsize;
  pcfuv.integerPart = floor(scaledUv) * invtexsize;
  pcfuv.fractionalPart = frac(scaledUv);
  return pcfuv;
}

#if defined(_VISION_DX11) && !defined(_DX9_ON_DX11)
  #define GetTexDepth(_lookupCoords, _step, _shadowTex, _shadowTexSampler) _GetTexDepth(_lookupCoords, _step, _shadowTex, _shadowTexSampler)
  inline float4 _GetTexDepth(float2 lookupCoords, float2 step, Texture2D shadowTex, sampler shadowTexSampler)
#elif defined(_VISION_PSP2)
  #define GetTexDepth(_lookupCoords, _step, _shadowTex, _shadowTexSampler) _GetTexDepth(_lookupCoords, _step, _shadowTex)
  inline float4 _GetTexDepth(float2 lookupCoords, float2 step, sampler2D shadowTex)
#else
  #define GetTexDepth(_lookupCoords, _step, _shadowTex, _shadowTexSampler) _GetTexDepth(_lookupCoords, _step, _shadowTex)
  inline float4 _GetTexDepth(float2 lookupCoords, float2 step, sampler2D shadowTex)
#endif
{
  float2 lookUp;
  float4 texDepth;
  
  lookUp.x = lookupCoords.x;
  lookUp.y = lookupCoords.y;
  
  #ifndef _VISION_PSP2
    
    texDepth.r = vTex2D(shadowTex, shadowTexSampler, lookUp).r;
    lookUp.x = lookupCoords.x + step.x;
    texDepth.g = vTex2D(shadowTex, shadowTexSampler, lookUp).r;
    lookUp.y = lookupCoords.y + step.y;
    texDepth.a = vTex2D(shadowTex, shadowTexSampler, lookUp).r;
    lookUp.x = lookupCoords.x;
    texDepth.b = vTex2D(shadowTex, shadowTexSampler, lookUp).r;
  
  #else
    
    texDepth.r = f1tex2D(shadowTex, lookUp);
    lookUp.x = lookupCoords.x + step.x;
    texDepth.g = f1tex2D(shadowTex, lookUp);
    lookUp.y = lookupCoords.y + step.y;
    texDepth.a = f1tex2D(shadowTex, lookUp);
    lookUp.x = lookupCoords.x;
    texDepth.b = f1tex2D(shadowTex, lookUp);  
    
  
  #endif
  
  return texDepth;
}

struct PCF16Samples_t
{
  float4 texDepth[4];
  float4 weights[4];
};


inline float ComputeShadowTerm(float4 texDepth, float pixDepth, float4 uv, float2 lerps)
{
  float4 st;
  st = saturate(ceil(-pixDepth + texDepth));
  float shadowTerm = lerp( lerp( st.r, st.g, lerps.x ),
                      lerp( st.b, st.a, lerps.x ),
                      lerps.y );
  return shadowTerm;
}

