//
#define _USE_DOWNLEVEL_DECLARATIONS
#include <shaders/VisionCommon.inc>
#include <shaders/ShaderHelpers.inc>

DECLARE_TEX2D_SAMPLER_4F(ShadowTex, ShadowTexSampler, 0)
#ifdef USE_SHADOWMAP
DECLARE_TEX2D_SAMPLER_1F(ShadowMap, ShadowMapSampler, 1)
#endif

#if defined(_VISION_PS3) || defined(_VISION_PSP2) || defined(_VISION_GLES2) || defined(_VISION_WIIU)
  float4 PrimaryColor : register(c32);
  
#elif defined(_VISION_DX11)
cbuffer g_GlobalConstantBufferUser : register (b2)
{
  float4 PrimaryColor : packoffset(c0);
}

#else
  float4 PrimaryColor;
  float4 InvScreenSize;
#endif

struct PS_IN 
{
  float4 ProjPos : SV_Position;      
  float4 ScreenPos : TEXCOORD0; 
#ifndef USE_SHADOWMAP
  float3 LightDir : TEXCOORD1;
  float3 Normal : TEXCOORD2;
#else
  float2 UV1 : TEXCOORD3;
#endif

#ifdef USE_FOG
  float fogCoord : TEXCOORD4;
#endif
};
 
float4 main( PS_IN In ) : SV_Target
{
  float2 screenPos = GetScreenTexPos(In.ScreenPos, InvScreenSize);

  #ifdef _VISION_XENON
    // Note: shadow information is only stored in the
    //   green channel, thus we avoid to overwrite the
    //   stencil values in EDRAM on xbox360 in case of
    //   interleaved shadow map rendering
	float shadowTerm = vTex2D(ShadowTex, ShadowMapSampler, screenPos).g;
  #else
	float shadowTerm = vTex2D(ShadowTex, ShadowMapSampler, screenPos).r;
  #endif  
  
  float4 fval = PrimaryColor + shadowTerm * (1.0 - PrimaryColor);
#if defined(TERRAIN)
	#ifdef USE_FOG
	fval.xyz = GetFogColor(fval.xyz, 1.0, In.fogCoord);
	#endif
	return float4(fval.xyz, 1.0f);
#else
	float4 color;
	#ifdef USE_SHADOWMAP
		float shadowMap = 1.0 - vTex2D(ShadowMap, ShadowMapSampler, In.UV1).r;
		color = max(fval, shadowMap.xxxx);
	#else
		color = max(fval, 1.0 - saturate(dot(In.LightDir, In.Normal)));
	#endif

	#ifdef USE_FOG
		color.xyz = GetFogColor(color.xyz, 1.0, In.fogCoord);
	#endif
	return float4(color.xyz, 1.0);
#endif  
/*
  */
  
}