//
#include <Shaders/VisionCommon.inc>

#ifdef ALPHA_TEST
#ifdef _VISION_DX11
  Texture2D <float4> BaseTex        : register(t0);
  sampler            BaseTexSampler : register(s0);
#else
  sampler2D          BaseTex        : register(s0);
#endif
#endif

struct PS_IN
{
  float4 ProjPos  : SV_Position;
#ifdef ALPHA_TEST
  float2 UV : TEXCOORD0;
#endif

#ifdef SHADOWING_MODE_VARIANCE
  float Depth : TEXCOORD1;
#elif defined(_VISION_DX9)
  float4 Pos : TEXCOORD1;
#endif
};

float4 main( PS_IN In ) : SV_Target
{
#ifdef ALPHA_TEST
  float baseAlpha = vTex2D(BaseTex, BaseTexSampler, In.UV).a;
  clip(baseAlpha-0.25);
#endif

#ifdef SHADOWING_MODE_VARIANCE
  return float4(In.Depth, In.Depth * In.Depth, 0.0f, 1.0f);
#else
  #ifdef _VISION_DX9
    return In.Pos.z / In.Pos.w;
  #else
    return 0.0;
  #endif
#endif
}



