//
#include <Shaders/VisionCommon.inc>

#ifdef _VISION_DX10
cbuffer g_GlobalConstantBufferFrame : register (b0)
{
  float4 clipPlanes : packoffset(c12);
  float4 cameraPos  : packoffset(c17);  // camera position
  
}

cbuffer g_GlobalConstantBufferObject : register (b1)
{
  float4x4 matMV    : packoffset(c0);   // model view matrix
  float4x4 matMVP   : packoffset(c4);   // model view projection matrix
  float4x4 matMtoW  : packoffset(c8);
}

cbuffer g_GlobalConstantBufferUser : register (b2)
{
  float4x4 InvWorldMat : packoffset(c0);
  float IsInside       : packoffset(c8);
}

#else
  float4x4 matMV    : register(c0);
  float4x4 matMVP   : register(c8);
  float4x4 matMtoW  : register(c20);
  float4x4 matView  : register(c12);
  
  float4 clipPlanes : register(c24);
  float4 cameraPos  : register(c31);
  
  #if defined(_VISION_PS3) || defined(_VISION_PSP2) || defined(_VISION_GLES2) || defined(_VISION_WIIU)
    float4x4 InvWorldMat : register(c64);
    float IsInside       : register(c72);
  #else
    float4x4 InvWorldMat;
    float IsInside;
  #endif
  
#endif


struct VS_IN
{
  float3   ObjPos  : POSITION;
};

struct VS_OUT
{
  float4   ProjPos    : SV_Position;
  
  float4   LocalRay   : TEXCOORD0;
  float4   ViewRay    : TEXCOORD1;
  float4   ShapePos   : TEXCOORD2;
  float4   ClipPlanes : TEXCOORD3;

  #if defined(_VISION_DX11)
    float4 ScreenPos : VPOS_MANUAL;
  #elif defined(_VISION_XENON)
    float4 ScreenPos : TEXCOORD4;
  #endif  
};

VS_OUT vs_main( VS_IN In )
{
  VS_OUT Out;
  
  // Vertex position (bounding box)
  Out.ProjPos  = mul( matMVP, float4(In.ObjPos, 1.0f) );
  if (IsInside > 0.5f)
  {
    Out.ProjPos.z = min(Out.ProjPos.z, Out.ProjPos.w);
  }

  // Local camera position
  float4 localCamPos = mul(InvWorldMat, cameraPos);
 
  // The center of the shape (translated so that the ray origin is at 0)
  Out.ShapePos  =  -localCamPos;
  
  // Ray directions in local and camera space
  Out.LocalRay  = float4(In.ObjPos - localCamPos, 1.0f);
  Out.ViewRay   = mul( matMV, Out.LocalRay );
  
  float4 worldPos = mul(matMtoW, float4(In.ObjPos,1));
  Out.ViewRay.w = length(worldPos.xyz - cameraPos);

  // Projected screen coordinates 
  #if defined(_VISION_DX11) || defined(_VISION_XENON)
    Out.ScreenPos = Out.ProjPos;
    Out.ScreenPos.y *= -1.0f;
  #endif
  
  // Far/near clip planes  
  Out.ClipPlanes = clipPlanes;
  
  return Out;
}
