#include <shaders/StaticLightingMobileHelpers.inc>

#ifdef _VISION_DX11

  cbuffer g_GlobalConstantBufferFrame : register (b0)
  {
    float4    Timer           : packoffset(c16);
    float4    eyePos          : packoffset(c17);  // eye position
    float4    depthFog        : packoffset(c19);  // linear depth fog parameter: near, far, 1/(far-near)
  }

  cbuffer g_GlobalConstantBufferObject : register (b1)
  {
    float4x4  matMV   : packoffset(c0);   // model view matrix
    float4x4  matMVP  : packoffset(c4);   // model view projection matrix
    float4x4  matMtoW : packoffset(c8);   // model to worldspace matrix
    float4    MUVtoLM : packoffset(c13);  // model UV to lightmap
  }

  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    float4 LightPos : packoffset(c0);
    $if VMATERIAL_BUMP && !LIGHTGRIDSIMPLE
      float4 LightDir : packoffset(c1);
    $endif
    float4 ScrollSpeed : packoffset(c2);
  }
  cbuffer g_GlobalConstantBufferLightGrid : register (b3)
  {
    $if LIGHTGRIDSIMPLE
      float4 LightDir : packoffset(c2);
    $endif
  }      
#else
  float4x4 matMVP : register(c8);
  float4x4 matMtoW : register(c20);
  float4 eyePos : register(c31);

  $ifdef LIGHTGRIDSIMPLE
    float4 LightDir : register(c34);
  $elif VMATERIAL_BUMP
    float4 LightDir : register(c64);
  $endif

  $if LIGHTMAP
    float4 MUVtoLM : register(c60);
  $endif
  
  $if !NOFOG
    float4 depthFog : register(c62);  // linear depth fog parameter: near, far, 1/(far-near)
  $endif

  $if VMATERIAL_BUMPANIMATED
    float4 Timer : register(c30);
    float4 ScrollSpeed : register(c65);
  $endif
#endif

struct VS_IN
{
  float3 VertexPosMS : V_VERTEX_STREAM_POSITION;

  // note that we need to use all this permutation variables here, otherwise the stream mask will not be correctly set 
  $if USE_NORMAL_VS
    float3 NormalMS : V_VERTEX_STREAM_NORMAL;
  $endif
  
  float2 UV0 : V_VERTEX_STREAM_BASETEXCOORD;
  
  $if !LIGHTGRIDSIMPLE
    float2 UV1 : V_VERTEX_STREAM_LIGHTMAPCOORD;
  $endif
  
  $if USE_TANGENT_VS
    float3 TangentMS : V_VERTEX_STREAM_TANGENT;
  $endif
};

PS_IN vs_main(VS_IN In)
{
  PS_IN Out;
  float4 VertexPosMS = float4(In.VertexPosMS, 1.0f);
  Out.ProjPos = mul(matMVP, VertexPosMS);
  
  #ifdef USE_EYEDIR
    float4 VertexPosWS = mul(matMtoW, VertexPosMS);
	
	// Normalize to avoid precision issues due to half3
	Out.EyeDirWS = normalize(VertexPosWS.xyz - eyePos.xyz);
  #endif

  Out.UV0 = half4(In.UV0, 0, 0); // base texture
  
  $if LIGHTMAP
    Out.UV1 = half4(In.UV1 * MUVtoLM.xy + MUVtoLM.zw, 0, 0);
  $else
    Out.UV1 = Out.UV0;
  $endif
  
  #if defined(USE_NORMALS_VS)
    half3x3 matMtoWRot = (half3x3)matMtoW;
    half3 NormalWS = normalize(mul(matMtoWRot, half3(In.NormalMS)));
  #endif
  
  #if defined(USE_NORMALS_PS)
    Out.NormalWS = NormalWS;
  #endif
  
  #if defined(USE_TANGENTSPACE_VS)
    half3 TangentWS = normalize(mul(matMtoWRot, half3(In.TangentMS)));
    half fMul = dot(half3(In.TangentMS), half3(In.TangentMS)) - 2.0h;  
    half3 BiNormalWS = normalize(cross(TangentWS, NormalWS)*fMul);
  #endif
  
   #if defined(USE_TANGENTSPACE_PS)
    Out.TangentWS = TangentWS;
    Out.BiNormalWS = BiNormalWS;
  #endif

  $if defined(VMATERIAL_BUMPANIMATED)
    Out.UV1 = Out.UV1.xyxy + Timer.xxxx * ScrollSpeed;
  $endif
  
  $if VMATERIAL_BUMP
    Out.LightDir.x = dot(TangentWS, LightDir.xyz);
    Out.LightDir.y = -dot(BiNormalWS, LightDir.xyz);
    Out.LightDir.z = dot(NormalWS, LightDir.xyz);
  $elif LIGHTGRIDSIMPLE
    Out.LightDir = LightDir.xyz;
  $endif

  $if !NOFOG
    Out.fogCoord = GetFogCoord(depthFog, Out.ProjPos.z);
  $endif

  return Out;
}