#include <Shaders/VisionCommon.inc>

const float3 LUM_VECTOR = float3(.299, .587, .114);

#ifdef _VISION_DX11
  Texture2D <float4> BaseTexture        : register(t0);
  sampler            BaseTextureSampler : register(s0);
#else
  sampler2D          BaseTexture        : register(s0);
#endif

#if defined(_VISION_PS3) || defined(_VISION_PSP2) || defined(_VISION_WIIU)
  float4 StepSize : register(c32);
#elif defined(_VISION_DX11)
  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    float4 StepSize : packoffset(c0);
  }
#else
  float4 StepSize;
#endif

struct PS_IN
{                  
  float4 ProjPos  : SV_Position;
  half2 UV0 : TEXCOORD0; 
};
   
half4 ps_main( PS_IN In ) : SV_Target
{
  // Do all the adds in LOG space, so must do each sample separately.
  // Linear texture sample will be linear, but that 'should' be a small error. 
  half logLum;
  logLum =  log( dot(vTex2D(BaseTexture, BaseTextureSampler, In.UV0+half2(-StepSize.x, -StepSize.y)).rgb, LUM_VECTOR) + 1e-2);
  logLum += log( dot(vTex2D(BaseTexture, BaseTextureSampler, In.UV0+half2(-StepSize.x,  StepSize.y)).rgb, LUM_VECTOR) + 1e-2);
  logLum += log( dot(vTex2D(BaseTexture, BaseTextureSampler, In.UV0+half2( StepSize.x, -StepSize.y)).rgb, LUM_VECTOR) + 1e-2);
  logLum += log( dot(vTex2D(BaseTexture, BaseTextureSampler, In.UV0+half2( StepSize.x,  StepSize.y)).rgb, LUM_VECTOR) + 1e-2);

  logLum *= 0.25h;
  return half4(logLum, 1.0h, 1.0h, 1.0h);
}