#include <Shaders/VisionCommon.inc>

const float3 LUM_VECTOR = float3(.299, .587, .114);

#ifdef _VISION_DX11
  Texture2D <float4> BaseTexture            : register(t0);
  sampler            BaseTextureSampler     : register(s0);
  Texture2D <float>  SceneLuminance         : register(t1);
  sampler            SceneLuminanceSampler  : register(s1);
#else
  sampler2D          BaseTexture            : register(s0);
  sampler2D          SceneLuminance         : register(s1);
#endif

#if defined(_VISION_PS3) || defined(_VISION_PSP2)
  float4x3 ColorTransform : register(c32);
  float4   MiddleGreyMaxLuminance : register(c36);
  #ifdef BLUR_FACTOR
    float    BlurFactor     : register(c37);
  #endif

#elif defined(_VISION_WIIU)
  float4x4 ColorTransform : register(c32); // TODO: Check if adaption of the c++ code is necessary
  float4   MiddleGreyMaxLuminance : register(c36);
  #ifdef BLUR_FACTOR
    float    BlurFactor     : register(c37);
  #endif

  
#elif defined(_VISION_DX11)
cbuffer g_GlobalConstantBufferUser : register (b2)
{
  float4x3 ColorTransform : packoffset(c0);
  float4   MiddleGreyMaxLuminance : packoffset(c3);
  #ifdef BLUR_FACTOR
    float    BlurFactor     : packoffset(c4);
  #endif
}
#else
  float4x3 ColorTransform;
  float4   MiddleGreyMaxLuminance;
  #ifdef BLUR_FACTOR
    float    BlurFactor;
  #endif
#endif

struct PS_IN
{                  
  float4 ProjPos  : SV_Position;
  float2 UV0 : TEXCOORD0; 
};

// Reinhard version
float4 ps_main( PS_IN In ) : SV_Target
{
  float4 scaledRGBA = vTex2D(BaseTexture, BaseTextureSampler, In.UV0);
  float fLuminance = vTex2D(SceneLuminance, SceneLuminanceSampler, float2(0.5f,0.5f)).r;

  float fMiddleGrey = MiddleGreyMaxLuminance.x;
  float fMaxLuminance = MiddleGreyMaxLuminance.y;

  // Tone mapping
  float fLumPixel = dot(scaledRGBA.rgb, LUM_VECTOR);    
  float fLumScaled = (fLumPixel * fMiddleGrey) / (fLuminance + 1e-5);    
  float fLumCompressed = (fLumScaled * (1 + (fLumScaled / (fMaxLuminance * fMaxLuminance)))) / (1 + fLumScaled);
  
  // Scale the HDR color by the compressed luminance value
  scaledRGBA.rgb *= fLumCompressed;
  scaledRGBA.a = 1.0f;

  // Factor in bloom value here

  // current implementation just clamps at 1
  float4 outRGBA;
  outRGBA.rgb = mul(scaledRGBA, ColorTransform);

  #ifdef BLUR_FACTOR
    outRGBA.a = BlurFactor;
  #else
    outRGBA.a = 1;
  #endif

  return outRGBA;
}
