

// helper function to compute texture coordinates of reflected render target.
inline float4 GetProjectedTexCoords(float3 inPos, float4 mmv0, float4 mmv1, float4 mmv2, float4 mmvpos, 
  float4 refPlaneS, float4 refPlaneT, float4 refPlaneQ)
{
  float4 eyePos;
  float4 InPos4 = float4(inPos, 1.0f);
  eyePos.x = dot(InPos4, mmv0);
  eyePos.y = dot(InPos4, mmv1);
  eyePos.z = dot(InPos4, mmv2);
  eyePos.w = 1.0f;
  eyePos += mmvpos;

  float4 outUV;
  outUV.w = dot(refPlaneQ, eyePos);
  outUV.x = dot(refPlaneS, eyePos)*0.5f + 0.5f*outUV.w;
  outUV.y = -dot(refPlaneT, eyePos)*0.5f + 0.5f*outUV.w;
  outUV.z = 0.0f;
  return outUV;
}


#ifndef _VISION_WIIU
  static const float2 speedScale[8] = {
     float2( 0.14383161, -0.14100790 ),
     float2( 0.94558609, -0.76890725 ), 
     float2( 0.34495938, 0.29387760 ), 
     float2( -0.81544232, -0.87912464 ), 
     float2( 0.97484398, 0.75648379 ), 
     float2( 0.53742981, -0.47373420 ), 
     float2( 0.79197514, 0.19090188 ), 
     float2( -0.81409955, 0.91437590 ), 
  };

  static const float normalMapUvScale[4] = { 0.25f, 0.5f, 1.0f, 2.0f };
  static const float normalMapScale[4] = { 2.0f, 1.0f, 0.5f, 0.25f };
  static const float normalMapInvAccWeights[4] = { 1.0f, 0.6666f, 0.5714f, 0.5333f };
#endif


#define  WATER_NORMAL_TFETCHES 4
#define  CAUSTICS_NORMAL_TFETCHES 3
#define  WATER_DISPLACEMENT_TFETCHES 2


#ifdef _VISION_DX11
#define GetCausticsNormalFromNormalMap(_baseUV, _fTimer, _fWaterFlowSpeed, _fStrength, _transform, _normalMap, _normalMapSampler) _GetCausticsNormalFromNormalMap(_baseUV, _fTimer, _fWaterFlowSpeed, _fStrength, _transform, _normalMap, _normalMapSampler);
inline float3 _GetCausticsNormalFromNormalMap(float2 baseUV, float fTimer, float2 fWaterFlowSpeed, float fStrength,  float4 transform, Texture2D normalMap, sampler normalMapSampler)
#else
#define GetCausticsNormalFromNormalMap(_baseUV, _fTimer, _fWaterFlowSpeed, _fStrength, _transform, _normalMap, _normalMapSampler) _GetCausticsNormalFromNormalMap(_baseUV, _fTimer, _fWaterFlowSpeed, _fStrength, _transform, _normalMap);
inline float3 _GetCausticsNormalFromNormalMap(float2 baseUV, float fTimer, float2 fWaterFlowSpeed, float fStrength, float4 transform, sampler2D normalMap)
#endif
{
#ifdef _VISION_WIIU
  float2 speedScale[8] = {
     float2( 0.14383161, -0.14100790 ),
     float2( 0.94558609, -0.76890725 ), 
     float2( 0.34495938, 0.29387760 ), 
     float2( -0.81544232, -0.87912464 ), 
     float2( 0.97484398, 0.75648379 ), 
     float2( 0.53742981, -0.47373420 ), 
     float2( 0.79197514, 0.19090188 ), 
     float2( -0.81409955, 0.91437590 ), 
  };

  float normalMapUvScale[4] = { 0.25f, 0.5f, 1.0f, 2.0f };
  float normalMapScale[4] = { 2.0f, 1.0f, 0.5f, 0.25f };
#endif

  float3 vNormal = float3(0.0f, 0.0f, 0.0f);

  UNROLL_LOOP
  for (int i=0; i<CAUSTICS_NORMAL_TFETCHES; i++)
  {
    float2 tpos = baseUV * normalMapUvScale[i] + speedScale[i] * fTimer;
    tpos += fWaterFlowSpeed;
#ifdef WATER_CAUSTICS_ROTATION
    // transform by rotation
    tpos = float2(tpos.x*transform.x + tpos.y*transform.y, tpos.x*transform.z + tpos.y*transform.w);
#endif
    
    // TODO: Use accurate detail normal map computation with tangent space.
    vNormal += (vTex2D(normalMap, normalMapSampler, tpos) - 0.5f) * normalMapScale[i];
  }
  vNormal.xy *= fStrength;
  return normalize(vNormal);
}

 
#ifdef _VISION_DX11
#define GetWaterHeightFromDisplacementMap(_baseUV, _fTimer, _fWaterFlowSpeed, _fStrength, _texSize, _dispMap, _dispMapSampler) _GetWaterHeightFromDisplacementMap(_baseUV, _fTimer, _fWaterFlowSpeed, _fStrength, _texSize, _dispMap, _dispMapSampler);
inline float _GetWaterHeightFromDisplacementMap(float2 baseUV, float fTimer, float2 fWaterFlowSpeed, float fStrength, float2 texSize, Texture2D dispMap, sampler dispMapSampler )
#else
#define GetWaterHeightFromDisplacementMap(_baseUV, _fTimer, _fWaterFlowSpeed, _fStrength, _texSize, _dispMap, _dispMapSampler) _GetWaterHeightFromDisplacementMap(_baseUV, _fTimer, _fWaterFlowSpeed, _fStrength, _texSize, _dispMap);
inline float _GetWaterHeightFromDisplacementMap(float2 baseUV, float fTimer, float2 fWaterFlowSpeed, float fStrength, float2 texSize, sampler2D dispMap)
#endif
{
#ifdef _VISION_WIIU
  float2 speedScale[8] = {
     float2( 0.14383161, -0.14100790 ),
     float2( 0.94558609, -0.76890725 ), 
     float2( 0.34495938, 0.29387760 ), 
     float2( -0.81544232, -0.87912464 ), 
     float2( 0.97484398, 0.75648379 ), 
     float2( 0.53742981, -0.47373420 ), 
     float2( 0.79197514, 0.19090188 ), 
     float2( -0.81409955, 0.91437590 ), 
  };

  float normalMapUvScale[4] = { 0.25f, 0.5f, 1.0f, 2.0f };
  float normalMapScale[4] = { 2.0f, 1.0f, 0.5f, 0.25f };
  float normalMapInvAccWeights[4] = { 1.0f, 0.6666f, 0.5714f, 0.5333f };
#endif

  float fHeight = 0.0f;
  
  UNROLL_LOOP
  for (int i=0; i<WATER_DISPLACEMENT_TFETCHES; i++)
  {
    float2 tpos = baseUV * normalMapUvScale[i] + speedScale[i] * fTimer;
    tpos += fWaterFlowSpeed;   
    
    // Fast bilinear filtering :-)
    #ifdef _VISION_DX11
      //fHeight += (dispMap.SampleLevel(dispMapSampler, tpos, 0.0f).r - 0.5f) * normalMapScale[i];
      
      float4 vTexVal = dispMap.SampleLevel(dispMapSampler, tpos, 0.0f).bagr;
      float2 fLerpVals = frac(tpos.xy * texSize);
      float2 fLerp1 = lerp(vTexVal.xz, vTexVal.yw, fLerpVals.x);
      fHeight += (lerp(fLerp1.x, fLerp1.y, fLerpVals.y) - 0.5f) * normalMapScale[i];
      
    #else
      #ifdef _VISION_XENON
        // Xbox360 seems to have an issue with wrapping in vertex textures, so we make sure our tpos is 0..1
        tpos = frac(tpos);
      #endif
      float4 vTexVal = vLoadTex2D(dispMap, tpos).bagr;
      float2 fLerpVals = frac(tpos.xy * texSize);
      float2 fLerp1 = lerp(vTexVal.xz, vTexVal.yw, fLerpVals.x);
      fHeight += (lerp(fLerp1.x, fLerp1.y, fLerpVals.y) - 0.5f) * normalMapScale[i];
    #endif
    
    
    //fHeight += (vLoadTex2D(dispMap, tpos).r - 0.5f) * normalMapScale[i];
  }
  fHeight *= fStrength * normalMapInvAccWeights[WATER_NORMAL_TFETCHES-1];
  return fHeight;
}


#ifdef _VISION_DX11
#define GetWaterNormalAndHeightFromNormalMap(_baseUV, _fTimer, _fWaterFlowSpeed, _fStrength, _normalMap, _normalMapSampler) _GetWaterNormalAndHeightFromNormalMap(_baseUV, _fTimer, _fWaterFlowSpeed, _fStrength, _normalMap, _normalMapSampler);
inline float4 _GetWaterNormalAndHeightFromNormalMap(float2 baseUV, float fTimer, float2 fWaterFlowSpeed, float fStrength, Texture2D normalMap, sampler normalMapSampler )
#else
#define GetWaterNormalAndHeightFromNormalMap(_baseUV, _fTimer, _fWaterFlowSpeed, _fStrength, _normalMap, _normalMapSampler) _GetWaterNormalAndHeightFromNormalMap(_baseUV, _fTimer, _fWaterFlowSpeed, _fStrength, _normalMap);
inline float4 _GetWaterNormalAndHeightFromNormalMap(float2 baseUV, float fTimer, float2 fWaterFlowSpeed, float fStrength, sampler2D normalMap)
#endif
{
#ifdef _VISION_WIIU
  float2 speedScale[8] = {
     float2( 0.14383161, -0.14100790 ),
     float2( 0.94558609, -0.76890725 ), 
     float2( 0.34495938, 0.29387760 ), 
     float2( -0.81544232, -0.87912464 ), 
     float2( 0.97484398, 0.75648379 ), 
     float2( 0.53742981, -0.47373420 ), 
     float2( 0.79197514, 0.19090188 ), 
     float2( -0.81409955, 0.91437590 ), 
  };

  float normalMapUvScale[4] = { 0.25f, 0.5f, 1.0f, 2.0f };
  float normalMapScale[4] = { 2.0f, 1.0f, 0.5f, 0.25f };
  float normalMapInvAccWeights[4] = { 1.0f, 0.6666f, 0.5714f, 0.5333f };
#endif

  float4 vNormal = float4(0.0f, 0.0f, 0.0f, 0.0f);
  
  UNROLL_LOOP
  for (int i=0; i<WATER_NORMAL_TFETCHES; i++)
  {
    float2 tpos = baseUV * normalMapUvScale[i] + speedScale[i] * fTimer;
    tpos += fWaterFlowSpeed;   
    vNormal += (vTex2D(normalMap, normalMapSampler, tpos) - 0.5f) * normalMapScale[i];
  }
  vNormal.xy *= fStrength;
  vNormal.w *= normalMapInvAccWeights[WATER_NORMAL_TFETCHES-1];
#ifdef WATER_FLIP_NORMAL
  vNormal.xyz = normalize(-vNormal.xyz);
#else
  vNormal.xyz = normalize(vNormal.xyz);
#endif
  return vNormal;
}


#ifdef _VISION_DX11
#define GetCausticsFromMap(_vNormal, _vLightDir, _causticsTexture, _causticsTextureSampler) _GetCausticsFromMap(_vNormal, _vLightDir, _causticsTexture, _causticsTextureSampler);
inline float3 _GetCausticsFromMap(float3 vNormal, float3 vLightDir, Texture2D causticsTexture, sampler causticsTextureSampler)
#else
#define GetCausticsFromMap(_vNormal, _vLightDir, _causticsTexture, _causticsTextureSampler) _GetCausticsFromMap(_vNormal, _vLightDir, _causticsTexture);
inline float3 _GetCausticsFromMap(float3 vNormal, float3 vLightDir, sampler2D causticsTexture)
#endif
{
  // 1.333 is the approx. refractive index of water
  float3 vRefraction = refract(vLightDir, vNormal, 1.3333f) * 0.5f + 0.5f;
  return vTex2D(causticsTexture, causticsTextureSampler, vRefraction.xy);
}


#ifdef _VISION_DX11
#define GetCausticsFromMapWithChromaticDispersion(_vNormal, _vLightDir, _causticsTexture, _causticsTextureSampler) _GetCausticsFromMapWithChromaticDispersion(_vNormal, _vLightDir, _causticsTexture, _causticsTextureSampler);
inline float3 _GetCausticsFromMapWithChromaticDispersion(float3 vNormal, float3 vLightDir, Texture2D causticsTexture, sampler causticsTextureSampler)
#else
#define GetCausticsFromMapWithChromaticDispersion(_vNormal, _vLightDir, _causticsTexture, _causticsTextureSampler) _GetCausticsFromMapWithChromaticDispersion(_vNormal, _vLightDir, _causticsTexture);
inline float3 _GetCausticsFromMapWithChromaticDispersion(float3 vNormal, float3 vLightDir, sampler2D causticsTexture)
#endif
{
  float3 vRefractionRed = refract(vLightDir, vNormal, 1.32f) * 0.5f + 0.5f;
  float3 vRefractionGreen = refract(vLightDir, vNormal, 1.33f) * 0.5f + 0.5f;
  float3 vRefractionBlue = refract(vLightDir, vNormal, 1.34f) * 0.5f + 0.5f;
  float3 vCaustics;
  vCaustics.r = vTex2D(causticsTexture, causticsTextureSampler, vRefractionRed.xy).r;
  vCaustics.g = vTex2D(causticsTexture, causticsTextureSampler, vRefractionGreen.xy).r;
  vCaustics.b = vTex2D(causticsTexture, causticsTextureSampler, vRefractionBlue.xy).r;
  
  return vCaustics;
}


#ifdef _VISION_DX11
#define GetWaterReflection(_normal, _normalScale, _projCoord, _reflectionTexture, _reflectionTextureSampler) _GetWaterReflection(_normal, _normalScale, _projCoord, _reflectionTexture, _reflectionTextureSampler);
inline float3 _GetWaterReflection(float3 normal, float normalScale, float4 projCoord, Texture2D reflectionTexture, sampler reflectionTextureSampler)
#else
#define GetWaterReflection(_normal, _normalScale, _projCoord, _reflectionTexture, _reflectionTextureSampler) _GetWaterReflection(_normal, _normalScale, _projCoord, _reflectionTexture);
inline float3 _GetWaterReflection(float3 normal, float normalScale, float4 projCoord, sampler2D reflectionTexture)
#endif
{
  float2 vReflectionCoord = projCoord.xy / projCoord.w;
  vReflectionCoord += normal.xy * normalScale;
  return vTex2D(reflectionTexture, reflectionTextureSampler, vReflectionCoord).xyz;
}


#ifdef _VISION_DX11
#define GetWaterRefraction(_normal, _normalScale, _uv, _refractionTexture, _refractionTextureSampler, _refractionCoords) _GetWaterRefraction(_normal, _normalScale, _uv, _refractionTexture, _refractionTextureSampler, _refractionCoords);
inline float3 _GetWaterRefraction(float3 normal, float normalScale, float2 uv, Texture2D refractionTexture, sampler refractionTextureSampler, out float2 refractionCoords)
#else
#define GetWaterRefraction(_normal, _normalScale, _uv, _refractionTexture, _refractionTextureSampler, _refractionCoords) _GetWaterRefraction(_normal, _normalScale, _uv, _refractionTexture, _refractionCoords);
inline float3 _GetWaterRefraction(float3 normal, float normalScale, float2 uv, sampler2D refractionTexture, out float2 refractionCoords)
#endif
{
  refractionCoords = uv + normal.xy * normalScale;
  return vTex2D(refractionTexture, refractionTextureSampler, refractionCoords).xyz;
}


inline float2 _GetScreenTexPos(float4 screenPos, float2 invScreenSize)
{
  float2 screenTexPos;
  #if defined(_VISION_DX11)
    screenTexPos = (screenPos.xy / screenPos.w) * 0.5f + 0.5f;
  #elif defined(_VISION_DX9) || defined(_VISION_XENON)
    screenTexPos = ((screenPos.xy / screenPos.w) + invScreenSize) * 0.5f + 0.5f;
  #elif defined(_VISION_PS3)
    screenTexPos = screenPos.xy * invScreenSize;
    screenTexPos.y = 1.0f - screenTexPos.y;
  #elif defined(_VISION_WIIU)
    screenTexPos = screenPos.xy * invScreenSize;
  #else
    screenTexPos = screenPos.xy * invScreenSize + 0.5f * invScreenSize;
  #endif
  
  return screenTexPos;
}


float GetFresnelTerm(float3 normal, float3 eyeVec, float power)
{
	float angle = 1.0f + dot(normal, eyeVec);
	float fresnel = pow(angle, power);
	return fresnel;
}


float3 GetFoamFade(float3 rawFoam, float fWaterDepth, float2 fFoamFadeHeights, float waveHeight, float waveFoamStrength, float shoreFoamStrength)
{
  float lerpFactor = saturate( (fWaterDepth - fFoamFadeHeights.x) / (fFoamFadeHeights.y - fFoamFadeHeights.x) );
  float3 foam = lerp(rawFoam, 0.0f, lerpFactor) * shoreFoamStrength;
  foam += rawFoam * saturate(waveHeight * waveFoamStrength);
  return foam;
}
 

#ifdef _VISION_DX11
#define GetWaterFoam(_baseUV, _foamScrollSpeed, _foamWobbleSpeed, _foamWobbleStrength, _worldPosition, _fTimer, _foamMap, _foamMapSampler) _GetWaterFoam(_baseUV, _foamScrollSpeed, _foamWobbleSpeed, _foamWobbleStrength, _worldPosition, _fTimer, _foamMap, _foamMapSampler);
inline float3 _GetWaterFoam(float2 baseUV, float2 foamScrollSpeed, float foamWobbleSpeed, float foamWobbleStrength, float3 worldPosition, float fTimer, Texture2D foamMap, sampler foamMapSampler )
#else
#define GetWaterFoam(_baseUV, _foamScrollSpeed, _foamWobbleSpeed, _foamWobbleStrength, _worldPosition, _fTimer, _foamMap, _foamMapSampler) _GetWaterFoam(_baseUV, _foamScrollSpeed, _foamWobbleSpeed, _foamWobbleStrength, _worldPosition, _fTimer, _foamMap);
inline float3 _GetWaterFoam(float2 baseUV, float2 foamScrollSpeed, float foamWobbleSpeed, float foamWobbleStrength, float3 worldPosition, float fTimer, sampler2D foamMap)
#endif
{
  float2 fScaledScrollSpeed = fTimer * foamScrollSpeed;
  float fScaledWobbleSpeed = fTimer * foamWobbleSpeed;
  
  float2 foamTexCoord = baseUV + fScaledScrollSpeed + sin(fScaledWobbleSpeed + worldPosition.x*foamWobbleStrength) * foamWobbleStrength * 0.5f;
  float2 foamTexCoord2 = baseUV + fScaledScrollSpeed * 2.0f + sin(fScaledWobbleSpeed + worldPosition.y*foamWobbleStrength) * foamWobbleStrength * 0.5f + 0.5f;
  return (vTex2D(foamMap, foamMapSampler, foamTexCoord).xyz+vTex2D(foamMap, foamMapSampler, foamTexCoord2).xyz)*0.5f;
}
