//
#include <Shaders/VisionCommon.inc>

#ifdef _VISION_DX10
cbuffer g_GlobalConstantBufferObject : register (b1)
{
  float4x4 matMVP   : packoffset(c4);   // model view projection matrix
}
#else
  float4x4 matMVP   : register(c8);
#endif


struct VS_IN
{
  float3 ObjPos  : POSITION;
  float3 UV0 : TEXCOORD0;  // xy=cubemap coordinates, z=horiz. cylinder angle
};

struct VS_OUT
{
  float4   ProjPos    : SV_Position;

  #if defined(_VISION_DX11)
    float4 ScreenPos : VPOS_MANUAL;
  #elif defined(_VISION_XENON)
    float4 ScreenPos : TEXCOORD0;
  #endif  
  
  float3 UV0 : TEXCOORD1;
  float3 ObjPos : TEXCOORD2;
};

VS_OUT vs_main( VS_IN In )
{
  VS_OUT Out;
  
  // Vertex position
  Out.ProjPos  = mul( matMVP, float4(In.ObjPos, 1.0f) );

  // Projected screen coordinates 
  #if defined(_VISION_DX11) || defined(_VISION_XENON)
    Out.ScreenPos = Out.ProjPos;
    Out.ScreenPos.y *= -1.0f;
  #endif

  Out.ProjPos.z = Out.ProjPos.w;
  Out.UV0 = In.UV0;
  Out.ObjPos = In.ObjPos;
  return Out;
}
