//
#include <Shaders/VisionCommon.inc>

#ifdef _VISION_DX11
  cbuffer g_GlobalConstantBufferFrame : register (b0)
  {
    float4x4 mInvEye : packoffset(c8);
    float4 vClipPlanes : packoffset(c12);
    float3 vEyePosWorld : packoffset(c17);
    float4 vDepthFogParams : packoffset(c19);
  }
  cbuffer g_GlobalConstantBufferObject : register (b1)
  {
    float4x4 mMVP : packoffset(c4);
  }
  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    float2 InvTexSize : packoffset(c0);
  }
#else
  float4x4 mMVP : register(c8);
  float4x4 mInvEye : register(c16);
  float3 vEyePosWorld : register(c31);
  float4 vClipPlanes : register(c24);
  float4 vDepthFogParams : register(c62);
  float2 InvTexSize : register(c64);
#endif
  

struct VS_IN                   
{                              
  float3 ObjPos : V_VERTEX_STREAM_POSITION;  
  float3 UV0 : V_VERTEX_STREAM_UV0;  
};                                           

struct VS_OUT                                 
{                                             
  float4 ProjPos  : SV_Position;              
  float4 UV0_DepthFog : TEXCOORD0;
};


VS_OUT vs_main_fog( VS_IN In )                        
{                                              
  VS_OUT Out;                                
  
  Out.ProjPos = float4(In.ObjPos.xy, 0.0f, 1.0f);
  Out.ProjPos.y *= -1.0f;
  
  float2 UV0;
  UV0 = In.ObjPos*0.5f + 0.5f;
  UV0.xy += InvTexSize * 0.5f;
   
  float2 DepthFog;
  DepthFog.x = vDepthFogParams.x * vDepthFogParams.z;
  DepthFog.y = vClipPlanes.y * vDepthFogParams.z;

  Out.UV0_DepthFog.xy = UV0;
  Out.UV0_DepthFog.zw = DepthFog;
   
  return Out;
}
