#include <shaders/DeferredShadingHelpers.inc>

Texture2DMS<float4, $MSAA_SAMPLES> AccumTexture : register(s0);
Texture2DMS<float2, $MSAA_SAMPLES> DepthTexture : register(s1);
Texture2DMS<float4, $MSAA_SAMPLES> DepthSpec : register(s2);

SamplerState Filter;

struct PS_IN
{
    float4 ProjPos : SV_Position;
    float2 UV : TEXCOORD0;
};

struct PS_OUT_CD
{
  float4 Accumulation : SV_Target0;
	float  DepthSpec : SV_Target1;
	float  Depth : SV_Depth0;
};

PS_OUT_CD ps_main( PS_IN In )
{
    PS_OUT_CD Out;
    int3 uv = int3(int2(In.ProjPos.xy), 0);
    
    Out.Accumulation = float4(0,0,0,0);
    float z = 0.0;
		float z2 = 0.0;

    [unroll]
    for (int i = 0; i < $MSAA_SAMPLES; i++)
    {
      Out.Accumulation += AccumTexture.Load( uv, i ) * (1.0 / $MSAA_SAMPLES);

			z = max (z, DepthTexture.Load( uv, i ).r);
			z2 = max (z2, DepthSpec.Load( uv, i ).r);
    }

    
    Out.Depth = z;
		Out.DepthSpec = z2;
    return Out;
}
