
inline float4 GetProjCoords(float3 vPos, float4 RefPlaneS, float4 RefPlaneT, float4 RefPlaneQ)
{
  float4 vProjCoords;
  vProjCoords = float4(vPos, 1.0f);
  float distq = dot(vProjCoords, RefPlaneQ); 
  float dists = dot(vProjCoords, RefPlaneS)*0.5f; 
  float distt = dot(vProjCoords, RefPlaneT)*0.5f; 
  vProjCoords.x = distq-(0.5f * distq + dists);  
  vProjCoords.y = distq-(0.5f * distq + distt); 
  vProjCoords.z = distq;                       
  vProjCoords.w = distq;
  return vProjCoords;
}

inline float4 GetOrthographicCoords(float3 vPos, float4 RefPlaneS, float4 RefPlaneT)
{
  float4 vProjCoords;
  vProjCoords = float4(vPos, 1.0f);
  float dists = dot(vProjCoords, RefPlaneS); 
  float distt = dot(vProjCoords, RefPlaneT); 
  vProjCoords.x = dists;
  vProjCoords.y = distt;
  vProjCoords.zw = float2(0.0f, 1.0f);
  return vProjCoords;
}



#ifdef _VISION_DX11
  #define GetTexDepth4(_lookupCoords, _offset, _shadowTex, _shadowTexSampler) _GetTexDepth4(_lookupCoords, _offset, _shadowTex, _shadowTexSampler)
  inline float4 _GetTexDepth4(float2 lookupCoords, float2 offset, Texture2D shadowTex, sampler shadowTexSampler)
#else
  #define GetTexDepth4(_lookupCoords, _offset, _shadowTex, _shadowTexSampler) _GetTexDepth4(_lookupCoords, _offset, _shadowTex)
  inline float4 _GetTexDepth4(float2 lookupCoords, float2 offset, sampler2D shadowTex)
#endif
{
  float2 lookUp;
  float4 texDepth;
  
  lookUp.x = lookupCoords.x;
  lookUp.y = lookupCoords.y;
  texDepth.r = vTex2D(shadowTex, shadowTexSampler, lookUp).r;
  lookUp.x = lookupCoords.x + offset.x;
  texDepth.g = vTex2D(shadowTex, shadowTexSampler, lookUp).r;
  lookUp.y = lookupCoords.y + offset.y;
  texDepth.a = vTex2D(shadowTex, shadowTexSampler, lookUp).r;
  lookUp.x = lookupCoords.x;
  texDepth.b = vTex2D(shadowTex, shadowTexSampler, lookUp).r;
  
  return texDepth;
}

struct PCFUV_t
{
  float2 integerPart;
  float2 fractionalPart;
};

inline PCFUV_t GetPCFCoords(float2 uv, float2 invtexsize)
{
  PCFUV_t pcfuv;
  float2 scaledUv = uv / invtexsize;
  pcfuv.integerPart = floor(scaledUv) * invtexsize;
  pcfuv.fractionalPart = frac(scaledUv);
  return pcfuv;
}

inline float ComputeShadowTerm(float4 texDepth, float pixDepth, float2 lerps)
{
  float4 st;
  st = saturate(ceil(-pixDepth + texDepth));
  float shadowTerm = lerp( lerp( st.r, st.g, lerps.x ),
                      lerp( st.b, st.a, lerps.x ),
                      lerps.y );
  return shadowTerm;
}

// Note: Depth values range from 1.0f (near) to 0.0f (far) -> inverse z!
float PenumbraSize(float zReceiver, float zBlocker) //Parallel plane estimation 
{ 
  return (zBlocker-zReceiver)/(1.0f-zReceiver);
} 

#ifdef USE_CHS
	#ifdef _VISION_DX11
	
		#define FILTER_SIZE    11
		#define FS  FILTER_SIZE
		#define FS2 ( FILTER_SIZE / 2 )

		// 4 control matrices for a dynamic cubic bezier filter weights matrix

		static const float C3[11][11] = 
						 { { 1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0 }, 
						   { 1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0 },
						   { 1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0 },
						   { 1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0 },
						   { 1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0 },
						   { 1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0 },
						   { 1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0 },
						   { 1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0 },
						   { 1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0 },
						   { 1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0 },
						   { 1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0 },
						   };

		static const float C2[11][11] = 
						 { { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 }, 
						   { 0.0,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.0 },
						   { 0.0,0.5,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.5,0.0 },
						   { 0.0,0.5,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.5,0.0 },
						   { 0.0,0.5,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.5,0.0 },
						   { 0.0,0.5,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.5,0.0 },
						   { 0.0,0.5,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.5,0.0 },
						   { 0.0,0.5,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.5,0.0 },
						   { 0.0,0.5,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.5,0.0 },
						   { 0.0,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.0 },
						   { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 },
						   };

		static const float C1[11][11] = 
						 { { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 }, 
						   { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 },
						   { 0.0,0.0,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.0,0.0 },
						   { 0.0,0.0,0.5,1.0,1.0,1.0,1.0,1.0,0.5,0.0,0.0 },
						   { 0.0,0.0,0.5,1.0,1.0,1.0,1.0,1.0,0.5,0.0,0.0 },
						   { 0.0,0.0,0.5,1.0,1.0,1.0,1.0,1.0,0.5,0.0,0.0 },
						   { 0.0,0.0,0.5,1.0,1.0,1.0,1.0,1.0,0.5,0.0,0.0 },
						   { 0.0,0.0,0.5,1.0,1.0,1.0,1.0,1.0,0.5,0.0,0.0 },
						   { 0.0,0.0,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.0,0.0 },
						   { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 },
						   { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 },
						   };

		static const float C0[11][11] = 
						 { { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 }, 
						   { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 },
						   { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 },
						   { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 },
						   { 0.0,0.0,0.0,0.0,0.2,0.2,0.2,0.0,0.0,0.0,0.0 },
						   { 0.0,0.0,0.0,0.0,0.2,1.0,0.2,0.0,0.0,0.0,0.0 },
						   { 0.0,0.0,0.0,0.0,0.2,0.2,0.2,0.0,0.0,0.0,0.0 },
						   { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 },
						   { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 },
						   { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 },
						   { 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 },
						   };

		// compute dynamic weight at a certain row, column of the matrix
		float Fw( int r, int c, float fL )
		{
			return (1.0-fL)*(1.0-fL)*(1.0-fL) * C0[r][c] +
				   fL*fL*fL * C3[r][c] +
				   3.0f * (1.0-fL)*(1.0-fL)*fL * C1[r][c]+
				   3.0f * fL*fL*(1.0-fL) * C2[r][c];
		} 

		#define BLOCKER_FILTER_SIZE    11
		#define BFS  BLOCKER_FILTER_SIZE
		#define BFS2 ( BLOCKER_FILTER_SIZE / 2 )

		#define SUN_WIDTH 16.0f
		   
		//======================================================================================
		// This shader computes the contact hardening shadow filter
		//======================================================================================
		float ComputeCHShadowTerm( float2 tc, float2 fc, float fDepth, Texture2D shadowTex, SamplerComparisonState shadowTexSampler, sampler shadowTexSampler2 )
		{
			float  s   = 0.0f;
			int    row;
			int    col;
			float  w = 0.0;
			float  avgBlockerDepth;
			float  blockerSum = 0;
			float  blockerCount = 0;
			float  fRatio;
			float4 v1[ FS2 + 1 ];
			float2 v0[ FS2 + 1 ];
			float2 off;
			
			// find number of blockers and sum up blocker depth
			for( row = -BFS2; row <= BFS2; row += 2 )
			{
				for( col = -BFS2; col <= BFS2; col += 2 )
				{
					float4 d4 = shadowTex.Gather( shadowTexSampler2, tc.xy, int2( col, row ) );
					//float4 b4  = ( ( 1.0f - fDepth ).xxxx < ( (1.0f).xxxx - d4 ) ) ? (0.0).xxxx : (1.0).xxxx;   
					float4 b4  = ( d4 > fDepth.xxxx ) ? (1.0).xxxx : (1.0).xxxx;   

					blockerCount += dot( b4, (1.0).xxxx );
					blockerSum   += dot( d4, b4 );
				}
			}

			// compute ratio using formulas from PCSS
			if( blockerCount > 0.0f )
			{
				avgBlockerDepth = blockerSum / blockerCount;
			    float penumbraRatio = PenumbraSize(fDepth, avgBlockerDepth);     
				float filterRadiusUV = (penumbraRatio * ShadowParameters.x) / (1.0f-fDepth); 
				
				fRatio = saturate( filterRadiusUV / 1.5f );
			}
			else
			{
				fRatio = 1.0f; 
			}
			
			[flatten] if( fRatio <= 0.1f )
			{
				fRatio = pow( ( fRatio * 10.0f ), 5.0f ) * 0.1f;
			}
			else
			{
				fRatio = ( pow( ( fRatio - 0.1f ) / 0.9f, 0.20f ) * 0.9f ) + 0.1f;  
			}
			
			// sum up weights of dynamic filter matrix
			for( row = 0; row < FS; ++row )
			{
			   for( col = 0; col < FS; ++col )
			   {
				  w += Fw(row,col,fRatio);
			   }
			}
			
			// filter shadow map samples using the dynamic weights
			[unroll(FILTER_SIZE)]for( row = -FS2; row <= FS2; row += 2 )
			{
				for( col = -FS2; col <= FS2; col += 2 )
				{
					float4 d4		 = shadowTex.GatherRed( shadowTexSampler2, tc.xy, int2( col, row ) );
					v1[(col+FS2)/2]  = ( ( 1.0f - fDepth ).xxxx < ( (1.0f).xxxx - d4 ) ) ? (1.0).xxxx : (0.0).xxxx;   
					//v1[(col+FS2)/2] = shadowTex.GatherCmpRed( shadowTexSampler, tc.xy, fDepth, 
					//										  int2( col, row ) );
		          
					if( col == -FS2 )
					{
						s += ( 1 - fc.y ) * ( v1[0].w * ( Fw(row+FS2,0,fRatio) - 
											  Fw(row+FS2,0,fRatio) * fc.x ) + v1[0].z * 
											( fc.x * ( Fw(row+FS2,0,fRatio) - 
											  Fw(row+FS2,1,fRatio) ) +  
											  Fw(row+FS2,1,fRatio) ) );
						s += (     fc.y ) * ( v1[0].x * ( Fw(row+FS2,0,fRatio) - 
											  Fw(row+FS2,0,fRatio) * fc.x ) + 
											  v1[0].y * ( fc.x * ( Fw(row+FS2,0,fRatio) - 
											  Fw(row+FS2,1,fRatio) ) +  
											  Fw(row+FS2,1,fRatio) ) );
						if( row > -FS2 )
						{
							s += ( 1 - fc.y ) * ( v0[0].x * ( Fw(row+FS2-1,0,fRatio) - 
												  Fw(row+FS2-1,0,fRatio) * fc.x ) + v0[0].y * 
												( fc.x * ( Fw(row+FS2-1,0,fRatio) - 
												  Fw(row+FS2-1,1,fRatio) ) +  
												  Fw(row+FS2-1,1,fRatio) ) );
							s += (     fc.y ) * ( v1[0].w * ( Fw(row+FS2-1,0,fRatio) - 
												  Fw(row+FS2-1,0,fRatio) * fc.x ) + v1[0].z * 
												( fc.x * ( Fw(row+FS2-1,0,fRatio) - 
												  Fw(row+FS2-1,1,fRatio) ) +  
												  Fw(row+FS2-1,1,fRatio) ) );
						}
					}
					else if( col == FS2 )
					{
						s += ( 1 - fc.y ) * ( v1[FS2].w * ( fc.x * ( Fw(row+FS2,FS-2,fRatio) - 
											  Fw(row+FS2,FS-1,fRatio) ) + 
											  Fw(row+FS2,FS-1,fRatio) ) + v1[FS2].z * fc.x * 
											  Fw(row+FS2,FS-1,fRatio) );
						s += (     fc.y ) * ( v1[FS2].x * ( fc.x * ( Fw(row+FS2,FS-2,fRatio) - 
											  Fw(row+FS2,FS-1,fRatio) ) + 
											  Fw(row+FS2,FS-1,fRatio) ) + v1[FS2].y * fc.x * 
											  Fw(row+FS2,FS-1,fRatio) );
						if( row > -FS2 )
						{
							s += ( 1 - fc.y ) * ( v0[FS2].x * ( fc.x * 
												( Fw(row+FS2-1,FS-2,fRatio) - 
												  Fw(row+FS2-1,FS-1,fRatio) ) + 
												  Fw(row+FS2-1,FS-1,fRatio) ) + 
												  v0[FS2].y * fc.x * Fw(row+FS2-1,FS-1,fRatio) );
							s += (     fc.y ) * ( v1[FS2].w * ( fc.x * 
												( Fw(row+FS2-1,FS-2,fRatio) - 
												  Fw(row+FS2-1,FS-1,fRatio) ) + 
												  Fw(row+FS2-1,FS-1,fRatio) ) + 
												  v1[FS2].z * fc.x * Fw(row+FS2-1,FS-1,fRatio) );
						}
					}
					else
					{
						s += ( 1 - fc.y ) * ( v1[(col+FS2)/2].w * ( fc.x * 
											( Fw(row+FS2,col+FS2-1,fRatio) - 
											  Fw(row+FS2,col+FS2+0,fRatio) ) + 
											  Fw(row+FS2,col+FS2+0,fRatio) ) +
											  v1[(col+FS2)/2].z * ( fc.x * 
											( Fw(row+FS2,col+FS2-0,fRatio) - 
											  Fw(row+FS2,col+FS2+1,fRatio) ) + 
											  Fw(row+FS2,col+FS2+1,fRatio) ) );
						s += (     fc.y ) * ( v1[(col+FS2)/2].x * ( fc.x * 
											( Fw(row+FS2,col+FS2-1,fRatio) - 
											  Fw(row+FS2,col+FS2+0,fRatio) ) + 
											  Fw(row+FS2,col+FS2+0,fRatio) ) +
											  v1[(col+FS2)/2].y * ( fc.x * 
											( Fw(row+FS2,col+FS2-0,fRatio) - 
											  Fw(row+FS2,col+FS2+1,fRatio) ) + 
											  Fw(row+FS2,col+FS2+1,fRatio) ) );
						if( row > -FS2 )
						{
							s += ( 1 - fc.y ) * ( v0[(col+FS2)/2].x * ( fc.x * 
												( Fw(row+FS2-1,col+FS2-1,fRatio) - 
												  Fw(row+FS2-1,col+FS2+0,fRatio) ) + 
												  Fw(row+FS2-1,col+FS2+0,fRatio) ) +
												  v0[(col+FS2)/2].y * ( fc.x * 
												( Fw(row+FS2-1,col+FS2-0,fRatio) - 
												  Fw(row+FS2-1,col+FS2+1,fRatio) ) + 
												  Fw(row+FS2-1,col+FS2+1,fRatio) ) );
							s += (     fc.y ) * ( v1[(col+FS2)/2].w * ( fc.x * 
												( Fw(row+FS2-1,col+FS2-1,fRatio) - 
												  Fw(row+FS2-1,col+FS2+0,fRatio) ) + 
												  Fw(row+FS2-1,col+FS2+0,fRatio) ) +
												  v1[(col+FS2)/2].z * ( fc.x * 
												( Fw(row+FS2-1,col+FS2-0,fRatio) - 
												  Fw(row+FS2-1,col+FS2+1,fRatio) ) + 
												  Fw(row+FS2-1,col+FS2+1,fRatio) ) );
						}
					}
		            
					if( row != FS2 )
					{
						v0[(col+FS2)/2] = v1[(col+FS2)/2].xy;
					}
				}
			}

			return 1.0f - ( s/w );
		}	
	
	#endif
#endif // USE_CHS 


#ifdef USE_PCSS

//#define PCF_REDUCED_FILTER_RADIUS 0.666f (ShadowParameters.y)
//#define PCF_FILTER_RADIUS 2.0f  (ShadowParameters.x)
//#define LIGHT_WORLD_SIZE 35.0 
//#define LIGHT_FRUSTUM_WIDTH 8192.0 
 
// Assuming that LIGHT_FRUSTUM_WIDTH == LIGHT_FRUSTUM_HEIGHT 
//#define LIGHT_SIZE_UV (LIGHT_WORLD_SIZE / LIGHT_FRUSTUM_WIDTH) (ShadowParameters.x)
 
static const float2 poissonDisk[16] = { 
   float2( 0.0, 0.0 ), //float2( 0.14383161, -0.14100790 ),
   float2( -0.94201624, -0.39906216 ), 
   float2( 0.94558609, -0.76890725 ), 
   float2( -0.094184101, -0.92938870 ), 
   float2( 0.34495938, 0.29387760 ), 
   float2( -0.91588581, 0.45771432 ), 
   float2( -0.81544232, -0.87912464 ), 
   float2( -0.38277543, 0.27676845 ), 
   float2( 0.97484398, 0.75648379 ), 
   float2( 0.44323325, -0.97511554 ), 
   float2( 0.53742981, -0.47373420 ), 
   float2( -0.26496911, -0.41893023 ), 
   float2( 0.79197514, 0.19090188 ), 
   float2( -0.24188840, 0.99706507 ), 
   float2( -0.81409955, 0.91437590 ), 
   float2( 0.19984126, 0.78641367 )
}; 
 
#ifdef _VISION_DX11
  #define FindBlocker(_avgBlockerDepth, _numBlockers, _uv, _zReceiver, _shadowTexture,  _shadowTextureSampler) _FindBlocker(_avgBlockerDepth, _numBlockers, _uv, _zReceiver, _shadowTexture, _shadowTextureSampler)
  void _FindBlocker(out float avgBlockerDepth, out float numBlockers, float2 uv, float zReceiver, Texture2D shadowTexture, sampler shadowTextureSampler) 
#else
  #define FindBlocker(_avgBlockerDepth, _numBlockers, _uv, _zReceiver, _shadowTexture,  _shadowTextureSampler) _FindBlocker(_avgBlockerDepth, _numBlockers, _uv, _zReceiver, _shadowTexture)
  void _FindBlocker(out float avgBlockerDepth, out float numBlockers, float2 uv, float zReceiver, sampler2D shadowTexture ) 
#endif
{
  float searchWidth = ((ShadowParameters.x * InvTexSize.x) * 2.0f * (1.0f - zReceiver)) / (2.0f - zReceiver);
  
  //searchWidth = min(searchWidth, 4.0f / 2048.f);//FIXME

  float blockerSum = 0; 
  numBlockers = 0; 
  
  for( int i = 0; i < BLOCKER_SEARCH_NUM_SAMPLES; ++i ) 
  { 
     //float shadowMapDepth = tDepthMap.SampleLevel( PointSampler, uv + poissonDisk[i] * searchWidth, 0); 
     float shadowMapDepth = vTex2D(shadowTexture, shadowTextureSampler, uv + poissonDisk[i] * searchWidth).r;
     if ( shadowMapDepth > zReceiver ) 
     { 
       blockerSum += shadowMapDepth; 
       numBlockers++; 
     } 
  } 

  avgBlockerDepth = blockerSum / numBlockers; 
} 
 
#ifdef _VISION_DX11
  #define PCF_Filter(_uv, _zReceiver, _filterRadiusUV, _shadowTexture, _shadowTextureSampler) _PCF_Filter(_uv, _zReceiver, _filterRadiusUV, _shadowTexture, _shadowTextureSampler)
  float _PCF_Filter( float2 uv, float zReceiver, float filterRadiusUV, Texture2D shadowTexture, sampler shadowTextureSampler ) 
#else
  #define PCF_Filter(_uv, _zReceiver, _filterRadiusUV, _shadowTexture, _shadowTextureSampler) _PCF_Filter(_uv, _zReceiver, _filterRadiusUV, _shadowTexture)
  float _PCF_Filter( float2 uv, float zReceiver, float filterRadiusUV, sampler2D shadowTexture ) 
#endif
{ 
    float sum = 0.0f; 
    #ifdef _VISION_PS3
    for ( int i = 0; i < PCF_NUM_SAMPLES; ++i ) 
    #else
    [unroll] for ( int i = 0; i < PCF_NUM_SAMPLES; ++i ) 
    #endif
    { 
        float2 offset = poissonDisk[i] * filterRadiusUV;
        sum += vTex2D(shadowTexture, shadowTextureSampler, uv + offset).r > zReceiver ? 1.0f : 0.0f;
        
        //sum += tDepthMap.SampleCmpLevelZero(PCF_Sampler, uv + offset, zReceiver); 
    } 
    return sum / PCF_NUM_SAMPLES; 
} 
 
#ifdef _VISION_DX11
  #define PCSS(_coords, _shadowTexture, _shadowTextureSampler) _PCSS(_coords, _shadowTexture, _shadowTextureSampler)
  float _PCSS ( float4 coords, Texture2D shadowTexture, sampler shadowTextureSampler ) 
#else
  #define PCSS(_coords, _shadowTexture, _shadowTextureSampler) _PCSS(_coords, _shadowTexture)
  float _PCSS ( float4 coords, sampler2D shadowTexture ) 
#endif
{ 
  float2 uv = coords.xy; 
  float zReceiver = coords.z; // Assumed to be eye-space z in this code 
  
  #ifdef USE_BLOCKER_SEARCH
    // STEP 1: blocker search 
    float avgBlockerDepth = 0; 
    float numBlockers = 0; 
    
    FindBlocker( avgBlockerDepth, numBlockers, uv, zReceiver, shadowTexture, shadowTextureSampler);
 
    //If there are no occluders -> early out (this saves filtering)
    if( numBlockers < 1 )   
      return 0.0f; 
 
    // STEP 2: penumbra size 
    float penumbraRatio = PenumbraSize(zReceiver, avgBlockerDepth);
    float filterRadiusUV = (penumbraRatio * (ShadowParameters.x * InvTexSize.x)) / (1.0f-coords.z); 
    filterRadiusUV = max(filterRadiusUV, InvTexSize.x);
  #else
    float filterRadiusUV = ShadowParameters.x * InvTexSize.x;
  #endif
     
  // filtering 
  return PCF_Filter( uv, zReceiver, filterRadiusUV, shadowTexture, shadowTextureSampler); 
}


#ifdef _VISION_DX11
  #define PCF_Filter_Reduced(_uv, _zReceiver, _filterRadiusUV, _shadowTexture, _shadowTextureSampler) _PCF_Filter_Reduced(_uv, _zReceiver, _filterRadiusUV, _shadowTexture, _shadowTextureSampler)
  float _PCF_Filter_Reduced( float2 uv, float zReceiver, float filterRadiusUV, Texture2D shadowTexture, sampler shadowTextureSampler ) 
#else
  #define PCF_Filter_Reduced(_uv, _zReceiver, _filterRadiusUV, _shadowTexture, _shadowTextureSampler) _PCF_Filter_Reduced(_uv, _zReceiver, _filterRadiusUV, _shadowTexture)
  float _PCF_Filter_Reduced( float2 uv, float zReceiver, float filterRadiusUV, sampler2D shadowTexture ) 
#endif
{ 
    float sum = 0.0f; 
    #ifdef _VISION_PS3
    for ( int i = 0; i < PCF_NUM_SAMPLES_REDUCED; ++i ) 
    #else   
    [unroll] for ( int i = 0; i < PCF_NUM_SAMPLES_REDUCED; ++i ) 
    #endif
    { 
        float2 offset = poissonDisk[i] * filterRadiusUV;
        sum += vTex2D(shadowTexture, shadowTextureSampler, uv + offset).r > zReceiver ? 1.0f : 0.0f;
        //sum += tDepthMap.SampleCmpLevelZero(PCF_Sampler, uv + offset, zReceiver); 
    } 
    return sum / PCF_NUM_SAMPLES_REDUCED; 
} 


#ifdef _VISION_DX1
  #define FindBlocker_Reduced(_avgBlockerDepth, _numBlockers, _uv, _zReceiver, _shadowTexture,  _shadowTextureSampler) _FindBlocker_Reduced(_avgBlockerDepth, _numBlockers, _uv, _zReceiver, _shadowTexture, _shadowTextureSampler)
  void _FindBlocker_Reduced(out float avgBlockerDepth, out float numBlockers, float2 uv, float zReceiver, Texture2D shadowTexture, sampler shadowTextureSampler) 
#else
  #define FindBlocker_Reduced(_avgBlockerDepth, _numBlockers, _uv, _zReceiver, _shadowTexture,  _shadowTextureSampler) _FindBlocker_Reduced(_avgBlockerDepth, _numBlockers, _uv, _zReceiver, _shadowTexture)
  void _FindBlocker_Reduced(out float avgBlockerDepth, out float numBlockers, float2 uv, float zReceiver, sampler2D shadowTexture ) 
#endif
{ 
  float searchWidth = ((ShadowParameters.x * InvTexSize.x) * 2.0f * (1.0f - zReceiver)) / (2.0f - zReceiver);

  float blockerSum = 0; 
  numBlockers = 0; 
     
  for( int i = 0; i < BLOCKER_SEARCH_NUM_SAMPLES_REDUCED; ++i ) 
  { 
     //float shadowMapDepth = tDepthMap.SampleLevel( PointSampler, uv + poissonDisk[i] * searchWidth, 0); 
     float shadowMapDepth = vTex2D(shadowTexture, shadowTextureSampler, uv + poissonDisk[i] * searchWidth);
     if ( shadowMapDepth > zReceiver ) 
     { 
       blockerSum += shadowMapDepth; 
       numBlockers++; 
     } 
  } 
 
  avgBlockerDepth = blockerSum / numBlockers; 
} 

#ifdef _VISION_DX11
  #define PCSS_Fast(_coords, _shadowTexture, _shadowTextureSampler) _PCSS_Fast(_coords, _shadowTexture, _shadowTextureSampler)
  float _PCSS_Fast ( float4 coords, Texture2D shadowTexture, sampler shadowTextureSampler ) 
#else
  #define PCSS_Fast(_coords, _shadowTexture, _shadowTextureSampler) _PCSS_Fast(_coords, _shadowTexture)
  float _PCSS_Fast (float4 coords, sampler2D shadowTexture ) 
#endif
{
  float2 uv = coords.xy; 
  float zReceiver = coords.z; // Assumed to be eye-space z in this code 
  
  #ifdef USE_BLOCKER_SEARCH_REDUCED
    // STEP 1: blocker search 
    float avgBlockerDepth = 0; 
    float numBlockers = 0; 
    FindBlocker_Reduced( avgBlockerDepth, numBlockers, uv, zReceiver, shadowTexture, shadowTextureSampler); 
 
    //If there are no occluders -> early out (this saves filtering) 
    if( numBlockers < 1 )   
      return 0.0f; 
 
    // STEP 2: penumbra size 
    float penumbraRatio = PenumbraSize(zReceiver, avgBlockerDepth);     
    float filterRadiusUV = (penumbraRatio * (ShadowParameters.x * InvTexSize.x)) / (1.0f-coords.z); 
    filterRadiusUV = max(filterRadiusUV, InvTexSize.x);
  #else
    float filterRadiusUV = ShadowParameters.y * InvTexSize.x;
  #endif
     
  // filtering 
  return PCF_Filter_Reduced( uv, zReceiver, filterRadiusUV, shadowTexture, shadowTextureSampler); 
}


#endif
