#include <Shaders/VisionCommon.inc>
#include <Shaders/ShaderHelpers.inc>
#include "DeferredShadingHelpers.inc"
#include "DeferredShadingShadowHelpers.inc"

#ifdef _VISION_DX11
  Texture2D <float4> DepthSpecBuffer        : register(t0);
  sampler            DepthSpecBufferSampler : register(s0);
  Texture2D <float4> NormalBuffer           : register(t1);
  sampler            NormalBufferSampler    : register(s1);
  Texture2D <float4> CircleTex              : register(t2);
  sampler            CircleTexSampler       : register(s2);
  Texture2D <float4> ShadowTex              : register(t3);
  sampler            ShadowTexSampler       : register(s3);
	
  #ifdef SHADOW_CASCADED
    Texture2D <float4> ShadowTex2             : register(t4);
    sampler            ShadowTex2Sampler      : register(s4);
  #endif

cbuffer g_GlobalConstantBufferUser : register (b2)
{
  float4 RefPlaneS : packoffset(c0);
  float4 RefPlaneT : packoffset(c1);
  float4 RefPlaneQ : packoffset(c2);
  float4 LightDir  : packoffset(c3);

  #ifdef SHADOW_CASCADED
    float4 RefPlaneS2 : packoffset(c4);
    float4 RefPlaneT2 : packoffset(c5);
    float4 RefPlaneQ2 : packoffset(c6);
  #endif  

  float4 clipPlanes : packoffset(c7);
  float4 InvTexSize : packoffset(c8);
}
  
#else
  sampler2D          DepthSpecBuffer        : register(s0);
  sampler2D          NormalBuffer           : register(s1);
  sampler2D          CircleTex              : register(s2);
  sampler2D          ShadowTex              : register(s3);

  #ifdef SHADOW_CASCADED
    sampler2D ShadowTex2 : register(s4);
  #endif

  float4 RefPlaneS : register(c32);
  float4 RefPlaneT : register(c33);
  float4 RefPlaneQ : register(c34);
  float4 LightDir  : register(c35);

  #ifdef SHADOW_CASCADED
    float4 RefPlaneS2 : register(c36);
    float4 RefPlaneT2 : register(c37);
    float4 RefPlaneQ2 : register(c38);
  #endif  

  float4 clipPlanes : register(c39);
  float4 InvTexSize : register(c40);
#endif

struct PS_IN                                 
{                                             
  float4 ProjPos  : SV_Position;              
  float3 ViewDirection : TEXCOORD0;
  float2 UV0 : TEXCOORD1;
  float3 EyePos : TEXCOORD2;
};


float4 ps_main_pcf4( PS_IN In ) : SV_Target
{
#ifdef _VISION_DX11
  // this is hack is necessary since DX10 does not compile
  // when there is a '-' modifier at the dot operator
  float3 vInverseLightDir = -LightDir;
  float3 vNormal = vTex2D(NormalBuffer, NormalBufferSampler, In.UV0).xyz * 2.0f - 1.0f;
  float fDotProd = dot(vNormal, LightDir);
#else
  float3 vNormal = vTex2D(NormalBuffer, NormalBufferSampler, In.UV0).xyz * 2.0f - 1.0f;
  float fDotProd = -dot(vNormal, LightDir);
#endif
  clip(fDotProd);
    
  float fDepth = vTex2D(DepthSpecBuffer, DepthSpecBufferSampler, In.UV0).r;
  clip(0.99999f-fDepth);
  
  float3 vPos = positionForDepth(fDepth, In.EyePos, In.ViewDirection);
  
  float4 vProjCoords = GetProjCoords(vPos, RefPlaneS, RefPlaneT, RefPlaneQ);
  
  
  #ifdef SHADOW_CASCADED
	float4 vProjCoords2 = GetProjCoords(vPos, RefPlaneS2, RefPlaneT2, RefPlaneQ2);
  #endif

  
  float pixDepth = (clipPlanes.g - vProjCoords.z) / clipPlanes.b;
  
  float2 vTexCoords = vProjCoords.xy / vProjCoords.w;
  PCFUV_t pcfUv = GetPCFCoords(vTexCoords, InvTexSize);
  float4 texDepth = GetTexDepth4(pcfUv.integerPart, InvTexSize, ShadowTex, ShadowTexSampler);
  float shadowTerm = ComputeShadowTerm(texDepth, pixDepth, pcfUv.fractionalPart);

  
  #ifdef SHADOW_CASCADED
    float2 vTexCoords2 = vProjCoords2.xy / vProjCoords2.w;
    PCFUV_t pcfUv2 = GetPCFCoords(vTexCoords2, InvTexSize);
    texDepth = GetTexDepth4(pcfUv2.integerPart, InvTexSize, ShadowTex2, ShadowTex2Sampler);
    float shadowTerm2 = ComputeShadowTerm(texDepth, pixDepth, pcfUv2.fractionalPart);
    
    float2 normCoords = vTexCoords - 0.5f;
    float lsquare = dot(normCoords, normCoords);
    float stepVal = step(0.2475f, lsquare);
    shadowTerm = lerp(shadowTerm, shadowTerm2, stepVal);
  #endif

  clip(shadowTerm - 0.005f);
  
  #ifdef SHADOW_CASCADED
    float4 cCircle = vTex2D(CircleTex, CircleTexSampler, vTexCoords2);
  #else
    float4 cCircle = vTex2D(CircleTex, CircleTexSampler, vTexCoords);
  #endif

  return float4(1.0f, 1.0f, 1.0f, 1.0f) - (cCircle * shadowTerm * fDotProd);
}


