//
#include <Shaders/VisionCommon.inc>

#ifdef _VISION_DX11
cbuffer g_GlobalConstantBufferFrame : register (b0)
{
  float4x4  matInvEye     : packoffset(c8);   // inverse eye matrix
  float3    eyePos        : packoffset(c17);  // eye position
}
cbuffer g_GlobalConstantBufferUser : register (b2)
{
  float2   InvTexSizeMask : packoffset(c0);
}
#else
  float4x4 matInvEye      : register(c16);
  float3   eyePos         : register(c31);
  float2   InvTexSizeMask : register(c64);
#endif

struct VS_IN                   
{                              
  float2 ObjPos : POSITION;  
  float3 UV0 : TEXCOORD0;  
};                                           

struct VS_OUT                                 
{                                             
  float4 ProjPos  : SV_Position;              
  float3 ViewDirection : TEXCOORD0;
  float2 UV0 : TEXCOORD1;
  float3 EyePos : TEXCOORD2;
};

VS_OUT vs_main( VS_IN In )                        
{                                              
  VS_OUT Out;                                
  
  Out.ProjPos = float4(In.ObjPos, 0.0f, 1.0f);
  Out.ProjPos.y *= -1.0f;
  
  Out.ViewDirection = mul(matInvEye, float4(In.UV0, 1.0f));
  
  Out.UV0 = In.ObjPos*0.5f + 0.5f;
  
  Out.UV0.xy += InvTexSizeMask * 0.5f;
    
  Out.EyePos = eyePos;
  return Out;
}
