//
#include <Shaders/VisionCommon.inc>

struct PS_IN
{
  float4 ProjPos  : SV_Position;
  float Depth 	  : TEXCOORD0;
  
  $ifdef ALPHATEST
    float2 UV       : TEXCOORD1;
  $endif
};


#ifdef _VISION_DX11
  Texture2D <float4> BaseTex        : register(t0);
  sampler            BaseTexSampler : register(s0);
  
  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    float AlphaThreshold : packoffset(c0);
  }
#elif defined(_VISION_PS3) || defined(_VISION_GLES2) || defined(_VISION_PSP2) || defined(_VISION_WIIU)
  sampler2D          BaseTex        : register(s0);
  float AlphaThreshold : register(c33);
#else
  sampler2D          BaseTex        : register(s0);
  float AlphaThreshold;
#endif


float4 main( PS_IN In ) : SV_Target
{
  $ifdef ALPHATEST
    float baseAlpha = vTex2D(BaseTex, BaseTexSampler, In.UV).a;
    clip(baseAlpha-AlphaThreshold);
  $endif
 
  return float4(In.Depth, 1.0f, 1.0f, 1.0f);
}


