//
#include <Shaders/VisionCommon.inc>

#include <Shaders/SkinningVS.inc>

struct VS_IN
{
  float3 ObjPos   : V_VERTEX_STREAM_POSITION;
  
  $ifdef ALPHATEST
    float2 UV       : V_VERTEX_STREAM_BASETEXCOORD;
  $endif

  SKINNING_VERTEX_STREAMS
};

struct VS_OUT
{
  float4 ProjPos  : SV_Position;
  float Depth 	  : TEXCOORD0;
  
  $ifdef ALPHATEST
    float2 UV       : TEXCOORD1;
  $endif
};


#ifdef _VISION_DX11
  cbuffer g_GlobalConstantBufferObject : register (b1)
  {
    float4x4 matMV  : packoffset(c0);   // model view matrix
    float4x4 matMVP : packoffset(c4);   // model view projection matrix
  }
#else
  float4x4 matMV  : register(c0);
  float4x4 matMVP : register(c8);
#endif

#ifdef _VISION_DX11
  cbuffer g_GlobalConstantBufferFrame : register (b0)
  {
    float4 ClipPlanes : packoffset(c12);
  }
#else
  float4 ClipPlanes : register(c24);
#endif


VS_OUT main( VS_IN In )
{
  VS_OUT Out;
 
  Out.ProjPos = mul( matMVP, float4(In.ObjPos, 1.0f) );
  
  float fDepth = Out.ProjPos.z;
    
  Out.Depth = (fDepth /*- ClipPlanes.x*/) / ClipPlanes.y;
  
  $ifdef ALPHATEST
    Out.UV = In.UV;
  $endif
  
  return Out;
}

#ifdef USE_SKINNING

  VS_OUT main_skinning( VS_IN In )
  {
    VS_OUT Out;
   
      // Skin In.ObjPos
    float4 ObjSpacePos;
    SKIN_NO_NORMAL(ObjSpacePos, In.ObjPos, In.BoneIndices, In.BoneWeight);
    Out.ProjPos = mul(matMVP, ObjSpacePos);
   
    float fDepth = Out.ProjPos.z;
      
    Out.Depth = (fDepth /*- ClipPlanes.x*/) / ClipPlanes.y;
    
    $ifdef ALPHATEST
      Out.UV = In.UV;
    $endif
    
    return Out;
  }

#endif

