#include <Shaders/VisionCommon.inc>
#include <Shaders/ShaderHelpers.inc>
#include <shaders/vMaterialPermutations.inc>

#ifdef _VISION_DX11
  Texture2D   BaseTexture         : register(t0);
  sampler     BaseTextureSampler  : register(s0);

  Texture2D   AttenTex            : register(t1);
  sampler     AttenTexSampler     : register(s1);
  
  $ifdef VMATERIAL_NORMALMAP
    Texture2D   NormalMap         : register(t2);
    sampler     NormalMapSampler  : register(s2);
  $endif

  $ifdef DYNLIGHT_OMNI_PROJECTOR
    TextureCube ProjTex           : register(t3);
    sampler     ProjTexSampler    : register(s3);
  $endif
  $ifdef DYNLIGHT_SPOT_PROJECTOR
    Texture2D   ProjTex           : register(t3);
    sampler     ProjTexSampler    : register(s3);
  $endif

  $ifdef VMATERIAL_REFMAP
    Texture2D   RefMap            : register(t4);
    sampler     RefMapSampler     : register(s4);
  $endif

  $ifdef SHADOWMAP
    Texture2D   ShadowTex         : register(t5);
    sampler     ShadowTexSampler  : register(s5);
  $endif

#else
  sampler2D   BaseTexture         : register(s0);   //Base texture
  sampler2D   AttenTex            : register(s1);   //Attenuation curve
  
  $ifdef VMATERIAL_NORMALMAP
    sampler2D   NormalMap         : register(s2);
  $endif

  $ifdef DYNLIGHT_OMNI_PROJECTOR
    samplerCUBE ProjTex           : register(s3);
  $endif
  $ifdef DYNLIGHT_SPOT_PROJECTOR
    sampler2D   ProjTex           : register(s3);
  $endif

  $ifdef VMATERIAL_REFMAP
    sampler2D   RefMap            : register(s4);
  $endif
  
  $ifdef SHADOWMAP
    sampler2D   ShadowTex         : register(s5);
  $endif
#endif

#if defined(_VISION_PS3) || defined(_VISION_PSP2) || defined(_VISION_GLES2) || defined(_VISION_WIIU)

  float4 MaterialParams : register(c32);
  float4 LightColor     : register(c33);
  float4 LightRadius    : register(c34);
  
  $ifdef DYNLIGHT_DIRECTIONAL
    float3 LightDirPS   : register(c35);
  $endif  
  $ifdef SHADOWMAP
    float2 InvScreenSize : register(c36);
  $endif  
  
#elif defined(_VISION_DX11)
  
  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    float4 MaterialParams : packoffset(c0); // x:specular mul, y:specular exp, z=Parallax Scaling, w=Parallax Bias. Same as for Material itself!
    float4 LightRadius    : packoffset(c1); // x:Radius, y:1/Radius (used for attenuation texture), z:Radius^2(not used), w:1/Radius^2(not used)
    float4 LightColor     : packoffset(c2); // xyz: color with pre-multiplied light multiplier
    
    $ifdef DYNLIGHT_DIRECTIONAL
      float3 LightDirPS   : packoffset(c3);
    $endif  
    $ifdef SHADOWMAP
      float2 InvScreenSize : packoffset(c4);
    $endif  
  }
#else
  float4 MaterialParams; // x:specular mul, y:specular exp, z=Parallax Scaling, w=Parallax Bias. Same as for Material itself!
  float4 LightRadius;    // x:Radius, y:1/Radius (used for attenuation texture), z:Radius^2(not used), w:1/Radius^2(not used)
  float4 LightColor;     // xyz: color with pre-multiplied light multiplier
  
  $ifdef DYNLIGHT_DIRECTIONAL
    float3 LightDirPS;
  $endif
  $ifdef SHADOWMAP
    float2 InvScreenSize;
  $endif    
#endif


$if (defined (DYNLIGHT_SPOT_PROJECTOR) || defined (DYNLIGHT_OMNI_PROJECTOR)) && defined (VMATERIAL_NORMALMAP) && defined (VMATERIAL_PARALLAX) && defined (VMATERIAL_SPECULAR)
	V_REQUIRES_SM30;
$endif
      
  struct PS_IN                                 
  {                                             
    float4 ProjPos      : SV_Position;
    
    $ifdef SHADOWMAP
      float4 UV0 : TEXCOORD0;     // u, v, screenX, screenY
    $else
      float2 UV0          : TEXCOORD0;
    $endif

  $ifdef USE_FOG
    float4 Normal  : TEXCOORD1; // encode fogcoord into w component because of limited amount of intepolators
  $else
    float3 Normal  : TEXCOORD1;
  $endif
    
    $ifdef VMATERIAL_NORMALMAP
      float3 Tangent      : TEXCOORD2;
      float3 BiTangent    : TEXCOORD3;
    $endif
    
    $ifdef VMATERIAL_SPECULAR
      float3 HalfAngleWS  : TEXCOORD4;
    $endif
    
    $ifdef SHADOWMAP
      float4 LightWS : TEXCOORD5;  // Lx, Ly, Lz, screenW
    $else
      float3 LightWS      : TEXCOORD5;
    $endif
    
    $ifdef DYNLIGHT_OMNI_PROJECTOR
      float3 ProjDir      : TEXCOORD6;
    $endif
    $ifdef DYNLIGHT_SPOT_PROJECTOR
      float4 ProjTexCoord : TEXCOORD6;
    $endif

    $ifdef VMATERIAL_PARALLAX
      float3 EyeDir       : TEXCOORD7;
    $endif
  };
  
#include <shaders/vMaterialHelpers.inc>

float4 ps_main( PS_IN In ) : SV_Target
{
  $ifdef DYNLIGHT_DIRECTIONAL
    float LightInt = 1;
  $elif DYNLIGHT_ATTENUATION_ONE_OVER_X
    float LightInt = rsqrt(dot(In.LightWS, In.LightWS));
    LightInt = saturate(LightInt*LightRadius.x - LightRadius.w);
  $else
    //Custom attenuation curve
    //float LightIntR = sqrt(dot(In.LightWS.xyz, In.LightWS.xyz)) * LightRadius.y;  // dist 0..1 for 0..r. Let the sampler clamp it to [0..1], not the shader
  
    float LightIntR = length(In.LightWS.xyz) * LightRadius.y;  // dist 0..1 for 0..r. Let the sampler clamp it to [0..1], not the shader
    LightIntR = saturate(LightIntR);

    #if defined(_VISION_GLES2)
      float LightInt = saturate(1.0 - LightIntR); //custom attenuation curve texture
    #else
      float LightInt = vTex2D(AttenTex, AttenTexSampler, float2(LightIntR, 0.0f)).x; //custom attenuation curve texture
    #endif
  $endif
  
  $ifdef DYNLIGHT_OMNI_PROJECTOR
    $ifdef DYNLIGHT_OMNI_PROJECTOR_DISTANCEMIPMAP
      // use a lower mipmap according to distance (assuming hardcoded first 4 miplevels)
      float4 ProjLightCol = LightColor*vTexCUBEbias(ProjTex, ProjTexSampler, float4(In.ProjDir,LightIntR*4.0));
    $else
      float4 ProjLightCol = LightColor*vTexCUBE(ProjTex, ProjTexSampler, In.ProjDir); // Cubemap projector
    $endif
  $elif defined(DYNLIGHT_SPOT_PROJECTOR)

    float4 ProjLightCol = LightColor * 
    #ifdef _VISION_PSP2
      // Use explicit clamping as the PSVita doesn't clamp correctly here.
      // TODO: check if this is fixed in future SDKs or find out how to use tex2Dproj for the PSVita
      tex2D(ProjTex, saturate(In.ProjTexCoord.xy / In.ProjTexCoord.w));
    #else
      vTex2Dproj(ProjTex, ProjTexSampler, In.ProjTexCoord); //2D spotlight projector
    #endif

  $else
    float4 ProjLightCol = LightColor; //No projector
  $endif

  $ifdef VMATERIAL_PARALLAX
    float3 vNormEyeTS = normalize(In.EyeDir);
	float2 BaseMapCoord = GetBaseMapCoords(In.UV0.xy, vNormEyeTS);
  $else
    float2 BaseMapCoord = In.UV0.xy;
  $endif

  float4 BaseMapValue = GetDiffuseTexture(BaseMapCoord);
  
  float4 NormalMapValue = GetTangentSpaceNormal(BaseMapCoord);
  $ifdef VMATERIAL_SPECULAR
    float4 SpecMul = GetSpecularMultiplier(BaseMapCoord, NormalMapValue.a);
    float fSpecExp = SpecMul.a;
  $endif
  
  $ifdef VMATERIAL_NORMALMAP
    NormalMapValue.xyz = GetWorldNormal(NormalMapValue, In.Tangent, In.BiTangent, In.Normal.xyz);
  $else  
    NormalMapValue = float4(normalize(In.Normal.xyz),1.f);
  $endif

  $ifdef DYNLIGHT_DIRECTIONAL
    float3 NormLightVec = -LightDirPS;
  $else
    float3 NormLightVec = normalize(In.LightWS.xyz);
  $endif
 
  float DotProd = saturate(dot(NormLightVec.xyz, NormalMapValue.xyz));

  float4 ResColor = BaseMapValue * LightInt * ProjLightCol * DotProd;
  
  $ifdef VMATERIAL_SPECULAR
    float SpecProd = GetSpecularIlluminationPoint(In.HalfAngleWS, NormalMapValue.xyz, fSpecExp);
    SpecProd = SpecProd * LightInt * DotProd;
    ResColor += SpecMul * SpecProd * ProjLightCol;
  $endif

  $ifdef DYNLIGHT_SPOT_PROJECTOR
    // Remove backprojection
    #ifdef _VISION_PSP2
      // There are artifacts where the W-Plane hits geometry because tex2Dproj is only emulated on the PSVita (see VisionCommon.inc)
      // -> use an epsilon.
      ResColor *= saturate(sign(In.ProjTexCoord.z - 0.05f));
    #else
      ResColor *= saturate(sign(In.ProjTexCoord.w));
    #endif
  $endif

  ResColor.a = BaseMapValue.a;

  $ifdef SHADOWMAP
    float2 ScreenTex = GetScreenTexPos(float4(In.UV0.zw, 0, In.LightWS.w), InvScreenSize);

    #ifdef _VISION_XENON
      // Note: shadow information is only stored in the
      //   green channel, thus we avoid to overwrite the
      //   stencil values in EDRAM on xbox360 in case of
      //   interleaved shadow map rendering
      ResColor.xyz *= vTex2D(ShadowTex, ShadowTexSampler, ScreenTex).g;
    #else
      ResColor.xyz *= vTex2D(ShadowTex, ShadowTexSampler, ScreenTex).rgb;
    #endif
  $endif
  
  $ifdef USE_FOG
    ResColor.xyz = GetFogColor(ResColor.xyz, float3(0.0f,0.0f,0.0f), In.Normal.w); 
  $endif  
  
  return ResColor;
}

