//
#include <Shaders/VisionCommon.inc>
#include "ShaderHelpers.inc"

#ifdef _VISION_DX10
cbuffer g_GlobalConstantBufferFrame : register (b0)
{
  float4 clipPlanes : packoffset(c12);
  float4 cameraPos  : packoffset(c17);  // camera position
  
  float4 DepthFogParams : packoffset(c19);
}

cbuffer g_GlobalConstantBufferObject : register (b1)
{
  float4x4 matMVP   : packoffset(c4);   // model view projection matrix
}

#else
  float4x4 matMVP   : register(c8);
  float4 clipPlanes : register(c24);
  float4 cameraPos  : register(c31);
  float4 DepthFogParams : register(c62);
  
  #if defined(_VISION_PS3) || defined(_VISION_PSP2)
    float4x4 InvWorldMat : register(c64);
  #else
    float4x4 InvWorldMat;
  #endif
#endif



struct VS_IN
{
  float3   ObjPos  : POSITION;
};

struct VS_OUT
{
  float4   ProjPos     : SV_Position;
  float4   CameraPos   : TEXCOORD0;
  float4   ClipPlanes  : TEXCOORD1;
  float4   FogCoord    : TEXCOORD2;

  #if defined(_VISION_DX11)
    float4 UV0 : VPOS_MANUAL;
  #elif defined(_VISION_XENON)
    float4 UV0 : TEXCOORD3;
  #endif  
};

VS_OUT vs_main( VS_IN In )
{
  VS_OUT Out;
  
  // Vertex position (bounding box)
  Out.ProjPos  = mul( matMVP, float4(In.ObjPos, 1.0f) );

  // Camera position/direction
  Out.CameraPos = cameraPos;
  
  // Projected screen coordinates 
  #if defined(_VISION_DX11) || defined(_VISION_XENON)
    Out.UV0 = Out.ProjPos;
    Out.UV0.y *= -1.0f;
  #endif

  // Far/near clip planes  
  Out.ClipPlanes = clipPlanes;
  
  Out.FogCoord = DepthFogParams;
  
  return Out;
}
