
#include <Shaders/VisionCommon.inc>
#include <Shaders/ShaderHelpers.inc>
#include <Shaders/SkinningVS.inc>

#ifdef _VISION_DX11
  cbuffer g_GlobalConstantBufferFrame : register (b0)
  {
    float4x4  matP          : packoffset(c0);
    float4   contextCP : packoffset(c12);  // context clip planes: near, far, 1/(far-near)
    float4   eyePos    : packoffset(c17);  // eye position
  }
  cbuffer g_GlobalConstantBufferObject : register (b1)
  {
    float4x4 matMV     : packoffset(c0);   // model view matrix
    float4x4 matMVP    : packoffset(c4);   // model view projection matrix
    float4x4 matMtoW   : packoffset(c8);   // model to worldspace matrix
    float4   MUVtoLM   : packoffset(c13);  // model UV to lightmap
  }

  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    float ZOffset; // exposed
  }
#else
  float4x4 matMV                  : register(c0);
  float4x4 matP                   : register(c4);
  float4x4 matMVP                 : register(c8);
  float4x4 matMtoW                : register(c20);
  float4   contextCP              : register(c24);
  float3   eyePos                 : register(c31);
  float4   MUVtoLM                : register(c60);
  float ZOffset; // exposed
#endif

struct VS_IN                   
{                              
  float3 ObjPos   : V_VERTEX_STREAM_POSITION;

  $ifdef VERTEXCOLOR
    float4 VertColor : V_VERTEX_STREAM_COLOR;
  $endif

  float3 Normal : V_VERTEX_STREAM_NORMAL;
  float2 UV0 : V_VERTEX_STREAM_BASETEXCOORD;
  float2 UV1 : V_VERTEX_STREAM_LIGHTMAPCOORD;
  
  $ifdef VMATERIAL_NORMALMAP
    float3 Tangent : V_VERTEX_STREAM_TANGENT;
  $endif

  SKINNING_VERTEX_STREAMS

};                                           

struct VS_OUT                                 
{                                             
  float4 ProjPos  : SV_Position;
  float4 UV01 : TEXCOORD0;
  float3 Normal  : TEXCOORD1;

  $ifdef VMATERIAL_NORMALMAP
    float3 Tangent : TEXCOORD2;
    float3 BiTangent: TEXCOORD3;
  $endif

  float4 EyeDirAndDepth : TEXCOORD4;

  $ifdef (VERTEXCOLOR) 
    float4 VertColor : TEXCOORD5;
  $endif
};      

#ifndef USE_SKINNING
  VS_OUT vs_main( VS_IN In )
#else
  VS_OUT vs_main_skinning( VS_IN In )
#endif
{
  VS_OUT Out;
  float4 objPos4 = float4(In.ObjPos, 1.0f);
  float3 fNormal = In.Normal;
  
  $ifdef VERTEXCOLOR
    Out.VertColor = In.VertColor;
  $endif
  
  $ifdef VMATERIAL_NORMALMAP
    float3 fTangent = In.Tangent;
  $endif
  
  #ifdef USE_SKINNING
  PREPARE_SKINNING(In.BoneIndices);
  TRANSFORM_OBJECT_POS(objPos4, In.ObjPos, In.BoneWeight);
  TRANSFORM_OBJECT_NORMAL(fNormal, In.Normal, In.BoneWeight);
  
    $ifdef VMATERIAL_NORMALMAP
      TRANSFORM_OBJECT_TANGENT(fTangent, In.Tangent, In.BoneWeight);
    $endif
  #endif  
  
  #ifdef EXPOSE_Z_OFS
    float4 eyePos = mul(matMV, objPos4);
    float3 eyeDir = normalize(eyePos.xyz);
    eyePos.xyz += eyeDir * ZOffset;
    Out.ProjPos = mul( matP, eyePos );
  #else
    Out.ProjPos = mul( matMVP, objPos4 );
  #endif
  
  Out.UV01.xy = In.UV0;

  $if defined (LIGHTMAP) || defined (LIGHTMAPDOT3)
    Out.UV01.zw = In.UV1*MUVtoLM.xy+MUVtoLM.zw; // lightmap xform
  $else
    Out.UV01.zw = In.UV1;
  $endif  
  
  //output normal, tangent and bi-tangent in worldspace
  Out.Normal  = normalize( mul((float3x3)matMtoW , fNormal) );
  
  $ifdef VMATERIAL_NORMALMAP
    Out.Tangent = normalize( mul((float3x3)matMtoW , fTangent) );
      Out.BiTangent = ComputeBiNormal(Out.Tangent, Out.Normal, GetHandednessCorrection(In.Tangent));
  $endif

  $if defined (VMATERIAL_PARALLAX) || defined (VMATERIAL_NORMALMAP)
    float4 worldSpacePos = mul(matMtoW, objPos4);
    Out.EyeDirAndDepth.xyz = GetVectorInTextureSpace(eyePos-worldSpacePos.xyz, Out.Tangent, Out.Normal, Out.BiTangent);
  $else
    Out.EyeDirAndDepth.xyz = float3(0.0f, 0.0f, 0.0f);
  $endif

  Out.EyeDirAndDepth.w = GetLinearDepth(mul(matMV, objPos4).z, contextCP.y);


  return Out;                              
}

