//
#include <Shaders/VisionCommon.inc>
#include <Shaders/ShaderHelpers.inc>

#ifdef _VISION_DX11
  Texture2D <float4> BaseTexture        : register(t0);
  sampler            BaseTextureSampler : register(s0);
  Texture3D <float4> GradingLUT         : register(t1);
  sampler            GradingLUTSampler  : register(s1);
#else
  sampler2D          BaseTexture        : register(s0);
  sampler3D          GradingLUT         : register(s1);
#endif

#ifdef USE_BLUR

	#if defined(_VISION_PS3) || defined(_VISION_WIIU)
	  float    BlurFactor     : register(c36);
	#elif defined(_VISION_DX11)
  	cbuffer g_GlobalConstantBufferUser : register (b2)
	  {
	    float    BlurFactor     : packoffset(c4);
	  }
	#else
	  float    BlurFactor;
	#endif

#endif


struct PS_IN
{                  
  float4 ProjPos  : SV_Position;
  half2 UV0 : TEXCOORD0; 
};

half4 ps_main( PS_IN In ) : SV_Target
{
  half4 origRGBA = vTex2D(BaseTexture, BaseTextureSampler, In.UV0);
$if defined(GAMMA_CORRECTION) && !defined(GAMMA_CORRECTION_POST_TRANSFORM)
  origRGBA.xyz = LinearToSRGB(origRGBA.xyz);
$endif

  half4 mappedRGBA = vTex3D(GradingLUT, GradingLUTSampler, origRGBA.xyz);

$if defined(GAMMA_CORRECTION_POST_TRANSFORM)
  mappedRGBA.xyz = LinearToSRGB(mappedRGBA.xyz);
$endif
    
  #ifdef USE_BLUR
    return half4(mappedRGBA.rgb, BlurFactor);
  #else
    return half4(mappedRGBA.rgb, origRGBA.a);
  #endif  
}
