#include <shaders/VisionCommon.inc>
#include <shaders/ShaderHelpers.inc>

$if VMATERIAL_BUMP
  #define USE_TANGENTSPACE_VS
  #define USE_NORMALMAP
  $redefine USE_NORMAL_VS = true
  $redefine USE_TANGENT_VS = true
$endif

$if VMATERIAL_BUMPANIMATED
  #define USE_TANGENTSPACE_VS
  #define USE_NORMALMAP
  $redefine USE_NORMAL_VS = true
  $redefine USE_TANGENT_VS = true
$endif

$if VMATERIAL_CUBEMAP
  #define USE_CUBEMAP
  #define USE_EYEDIR
  #define USE_NORMALS_PS
  $redefine USE_NORMAL_VS = true
$endif

$if VMATERIAL_BUMPCUBEMAP
  #define USE_CUBEMAP
  #define USE_EYEDIR
  
  #if !defined(USE_NORMALMAP)
    #define USE_NORMALMAP
  #endif
	
  #define USE_TANGENTSPACE_PS
  $redefine USE_NORMAL_VS = true
  $redefine USE_TANGENT_VS = true
$endif

$if VMATERIAL_FAKESPECBUMP
  #define USE_CUBEMAP
  #define USE_EYEDIR
  #define USE_NORMALMAP
  #define USE_TANGENTSPACE_PS
$endif

$if LIGHTGRIDSIMPLE
  #if !defined(USE_NORMALS_PS)
	#define USE_NORMALS_PS
  #endif
  $redefine USE_NORMAL_VS = true
$endif

#if defined(USE_TANGENTSPACE_PS) && !defined(USE_NORMALS_PS)
  #define USE_NORMALS_PS
#endif

#if defined(USE_TANGENTSPACE_PS) && !defined(USE_TANGENTSPACE_VS)
  #define USE_TANGENTSPACE_VS
#endif

#if defined(USE_NORMALS_PS) && !defined(USE_NORMALS_VS)
  #define USE_NORMALS_VS
#endif

#if defined(USE_TANGENTSPACE_VS) && !defined(USE_NORMALS_VS)
  #define USE_NORMALS_VS
#endif

#if defined(_VISION_GLES2)
  #define FIXED fixed
  #define FIXED2 fixed2
  #define FIXED3 fixed3
  #define FIXED4 fixed4
#else
  #define FIXED half
  #define FIXED2 half2
  #define FIXED3 half3
  #define FIXED4 half4
#endif

struct PS_IN
{
  float4 ProjPos  : SV_Position;
  half4 UV0 : TEXCOORD0;  //diffuse & normalmap
  half4 UV1 : TEXCOORD1;  //lightmap

  $ifndef NOFOG
    half fogCoord : TEXCOORD2;
  $endif
  
  $if VMATERIAL_BUMP || LIGHTGRIDSIMPLE
    half3 LightDir : TEXCOORD3;
  $endif
  
  #if defined(USE_EYEDIR)
    half3 EyeDirWS : TEXCOORD4;  
  #endif
  
  #if defined(USE_NORMALS_PS)
    half3 NormalWS : TEXCOORD5;
  #endif
  
  #if defined(USE_TANGENTSPACE_PS)  
    half3 TangentWS : TEXCOORD6;
    half3 BiNormalWS : TEXCOORD7;
  #endif
};