#include <Shaders/VisionCommon.inc>

#ifdef _VISION_DX11
  Texture2D <float> BaseTexture              : register(t0);
  sampler           BaseTextureSampler       : register(s0);

  #ifdef FACTOR_PREVIOUS_LUMINANCE
    Texture2D <float> PreviousSceneLuminance : register(t1); 
    sampler    PreviousSceneLuminanceSampler : register(s1); 
  #endif
#else
  sampler2D         BaseTexture              : register(s0);

  #ifdef FACTOR_PREVIOUS_LUMINANCE
    sampler2D       PreviousSceneLuminance  : register(s1);
  #endif
#endif

#if defined(_VISION_PS3) || defined(_VISION_PSP2) || defined(_VISION_WIIU)
  float4 StepSize : register(c32);
  
  #ifdef FACTOR_PREVIOUS_LUMINANCE
    float4 DeltaTimeApertureFactor : register(c33);
  #endif

#elif defined(_VISION_DX11)
  cbuffer g_GlobalConstantBufferUser : register (b2)
  {
    float4 StepSize : packoffset(c0);

    #ifdef FACTOR_PREVIOUS_LUMINANCE
      float4 DeltaTimeApertureFactor : packoffset(c1);
    #endif
  }
#else
  float4 StepSize;

  #ifdef FACTOR_PREVIOUS_LUMINANCE
    float4 DeltaTimeApertureFactor;
  #endif

#endif


struct PS_IN
{                  
  float4 ProjPos : SV_Position; // Not needed...
  half2 UV0 : TEXCOORD0; 
};
   
half4 ps_main( PS_IN In ) : SV_Target
{
  half fLogLuminance = 0.0h; 
  half2 SampleUV = In.UV0 - StepSize.xy;
  for( int y=0; y<3; ++y, SampleUV.y+=StepSize.y, SampleUV.x=In.UV0.x-StepSize.x )
  {
    for( int x=0; x<3; ++x, SampleUV.x+=StepSize.x )
    {
      fLogLuminance += vTex2D(BaseTexture, BaseTextureSampler, SampleUV).r;
    }
  }

  fLogLuminance *= (1.0h/9.0h);

  #ifdef FACTOR_PREVIOUS_LUMINANCE

    // In the final pass, convert to linear luminance and factor in previous luminance
    half fCurrentLuminance = exp(fLogLuminance);
    half fPrevLuminance = clamp (vTex2D(PreviousSceneLuminance, PreviousSceneLuminanceSampler, half2(0.5h,0.5h)).r, 0.0h, 10.0h);

    // Use Pattanaik's technique to smooth out the luminance changes as the lighting in the scene changes (aperture)
    
    #ifdef _VISION_WIIU
    half fDeltaTime = DeltaTimeApertureFactor.x;
    half fTau = DeltaTimeApertureFactor.y;
    #else
    const half fDeltaTime = DeltaTimeApertureFactor.x;
    const half fTau = DeltaTimeApertureFactor.y;
    #endif
    fCurrentLuminance = fPrevLuminance + (fCurrentLuminance - fPrevLuminance) * (1 - exp(-fDeltaTime * fTau)); 
    return half4(fCurrentLuminance, 1.0h, 1.0h, 1.0h);

  #else

    // During downsampling, write out the value to the next smaller surface
    return half4(fLogLuminance, 1.0h, 1.0h, 1.0h);

  #endif
}
