// Includes
#include <Shaders/VisionCommon.inc>

#if defined(_VISION_PS3) || defined(_VISION_PSP2) || defined(_VISION_GLES2) || defined(_VISION_WIIU)
  float4x4 matMV     : register(c0);
  float4x4 matP      : register(c4);
  float4x4 matMVP     : register(c8);
  float4x4 matModelToWorld : register(c20);
  float4   ClipPlanes : register(c24);
  float4   TimerVS : register(c30);
  float3   eyePos    : register(c31);

  #ifdef USE_TIME_OF_DAY
    float3 g_SunDirection : register(c56);
    float3 g_SunColor : register(c57);
  #endif

  float4 depthFog : register(c62);  // linear depth fog parameter: near, far, 1/(far-near)

  float4   refPlaneS  : register(c64);
  float4   refPlaneT  : register(c65);
  float4   refPlaneQ  : register(c66);
  float4   mmv0       : register(c67);
  float4   mmv1       : register(c68);
  float4   mmv2       : register(c69);
  float4   mmvpos     : register(c70);
  
  float2   BaseUVOffset : register(c71);
  float2   WaterSize : register(c72);
  
  #ifdef USE_VERTEX_DISPLACEMENT
    sampler2D NormalMapVS : register(s0);
    
    float3 waterNormalParams : register(c73);
    float2 waterFlowDirection : register(c74);
    float2 waterDisplacementStrength : register(c75);
    float2 normalMapSize : register(c76);
  #endif
  
#elif defined(_VISION_DX11)
  cbuffer g_GlobalConstantBufferFrame : register (b0)
  {
    float4x4 matP      : packoffset(c0);
    float4 ClipPlanes : packoffset(c12);
    float4 TimerVS : packoffset(c16);
    float3    eyePos          : packoffset(c17);  // eye position
    float4    depthFog        : packoffset(c19);  // linear depth fog parameter: near, far, 1/(far-near)
    #ifdef USE_TIME_OF_DAY
      float3 g_SunDirection : packoffset(c24);
      float3 g_SunColor : packoffset(c25);
    #endif
  }
  cbuffer g_GlobalConstantBufferObject : register (b1)
  {
    float4x4 matMV     : packoffset(c0);   // model view matrix
    float4x4 matMVP     : packoffset(c4);   // model view projection matrix
    float4x4 matModelToWorld : packoffset(c8);
  }
  cbuffer g_GlobalConstantBufferUserVS : register (b2)
  {
    float4   refPlaneS  : packoffset(c0);
    float4   refPlaneT  : packoffset(c1);
    float4   refPlaneQ  : packoffset(c2);
    float4   mmv0       : packoffset(c3);
    float4   mmv1       : packoffset(c4);
    float4   mmv2       : packoffset(c5);
    float4   mmvpos     : packoffset(c6);
 
    float2   BaseUVOffset : packoffset(c7);
    float2   WaterSize : packoffset(c8);
    
    #ifdef USE_VERTEX_DISPLACEMENT
      float3 waterNormalParams : packoffset(c9);
      float2 waterFlowDirection : packoffset(c10);
      float2 waterDisplacementStrength : packoffset(c11);     
      float2 normalMapSize : packoffset(c12);
    #endif
  }
  
  #ifdef USE_VERTEX_DISPLACEMENT
    Texture2D <float4> NormalMapVS      : register(t0);
    sampler            NormalMapSampler : register(s0);
  #endif    

 
#else
  float4x4 matMV     : register(c0);
  float4x4 matP      : register(c4);
  float4x4 matMVP     : register(c8); 
  float4x4 matModelToWorld : register(c20);
  float4   ClipPlanes : register(c24);
  float3   eyePos    : register(c31);
  float4 depthFog : register(c62);  // linear depth fog parameter: near, far, 1/(far-near)
   
  float4 TimerVS : register(c30);
  
  #ifdef USE_TIME_OF_DAY
    float3 g_SunDirection : register(c56);
    float3 g_SunColor : register(c57);
  #endif
   
  float4   refPlaneS;
  float4   refPlaneT;
  float4   refPlaneQ;
  float4   mmv0;
  float4   mmv1;
  float4   mmv2;
  float4   mmvpos;
  
  float2   BaseUVOffset; 
  float2   WaterSize;

  #ifdef USE_VERTEX_DISPLACEMENT
    sampler2D NormalMapVS : register(s0);
    
    float3 waterNormalParams;
    float2 waterFlowDirection;
    float2 waterDisplacementStrength; 
    float2 normalMapSize;
  #endif
  
#endif


struct VS_IN
{
  float3   ObjPos     : POSITION;
  float2   UVBase     : TEXCOORD0;
};

struct VS_OUT                                 
{                                             
  float4   ProjPos    : SV_Position;              
  float4   UVProj     : TEXCOORD0;
  float4   EyePosAndDepth : TEXCOORD1;
  float2   UVBase : TEXCOORD2;
  #ifdef WATER_SM20  
  float4   WorldSpacePos : TEXCOORD3;
  #else
  float3   WorldSpacePos : TEXCOORD3;
  #endif
  
  #ifdef USE_FOG
    float2 fogCoord : TEXCOORD4;
  #endif
  
  #ifdef USE_TIME_OF_DAY
    float3 vSunDirection : TEXCOORD5;
    float3 vSunColor : TEXCOORD6;
  #endif
  
  #if defined(_VISION_DX11) || defined(_VISION_DX9) || defined(_VISION_XENON)
    float4 ScreenPos : TEXCOORD7;
  #endif
};                                             

#include "ShaderHelpers.inc"
#include "WaterShaderHelpers.inc"
	

VS_OUT vs_main_water( VS_IN In )
{
  VS_OUT Out;
  
  Out.UVBase = (In.UVBase + BaseUVOffset) * WaterSize;
  
  float4 objPosition = float4(In.ObjPos, 1.0f);
  float3 reflPosition = objPosition.xyz;
  
  #ifdef USE_VERTEX_DISPLACEMENT 
    float fDisplacementFade = saturate(1.0f - length(In.UVBase.xy) * 4.0f * waterDisplacementStrength.y);
    float2 scaledUvBase = Out.UVBase * waterNormalParams.y;
    objPosition.z += fDisplacementFade * GetWaterHeightFromDisplacementMap(scaledUvBase, TimerVS.x * waterNormalParams.x, TimerVS.x * waterFlowDirection, waterDisplacementStrength.x, normalMapSize, NormalMapVS, NormalMapSampler);
    
    reflPosition = objPosition.xyz;
/*    
    float3 sobjPosition = objPosition.xyz - float3(BaseUVOffset, 0.0f);
    sobjPosition.xy *= WaterSize;
   
    float3 dir = sobjPosition.xyz - eyePos.xyz;
    float  t = (sobjPosition.z - In.ObjPos.z) / dir.z;
    reflPosition = eyePos.xyz + t * dir;
*/    
  #endif   

  Out.ProjPos = mul( matMVP, objPosition );

  
  Out.WorldSpacePos.xyz = mul(matModelToWorld, objPosition ).xyz;
  #ifdef WATER_SM20  
    Out.WorldSpacePos.w = TimerVS.x;
  #endif
  
  Out.UVProj = GetProjectedTexCoords(reflPosition, mmv0, mmv1, mmv2, mmvpos, refPlaneS, refPlaneT, refPlaneQ);
  //Out.UVProj = GetProjectedTexCoords(In.ObjPos, mmv0, mmv1, mmv2, mmvpos, refPlaneS, refPlaneT, refPlaneQ);
  
  #if defined(_VISION_DX11) || defined(_VISION_DX9) || defined(_VISION_XENON)
    Out.ScreenPos = Out.ProjPos;
    Out.ScreenPos.y *= -1.0f;
  #endif
  
  Out.EyePosAndDepth.xyz = eyePos.xyz;
  
  float4 eyeSpacePos = mul(matMV, objPosition);
  
  #if defined(_VISION_PS3) || defined(_VISION_PSP2)
  Out.EyePosAndDepth.w = -dot (matMV._31_32_33_34, objPosition.xyzw);
  #elif defined(_VISION_WIIU)
  Out.EyePosAndDepth.w = -dot (float4(matMV[2][0], matMV[2][1], matMV[2][2], matMV[2][3]), objPosition.xyzw);
  #else
  Out.EyePosAndDepth.w = dot (matMV._31_32_33_34, objPosition.xyzw);
  #endif
  
  // depth fog
  #ifdef USE_FOG
    Out.fogCoord = depthFog.xy;
  #endif

  #ifdef USE_TIME_OF_DAY
    Out.vSunDirection = g_SunDirection;
    Out.vSunColor = g_SunColor;
  #endif
   
  return Out;
}